package de.uka.ipd.sdq.pcm.codegen.simucom.transformations.sim;

import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.ComposedStructureXpt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.PCMext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.palladiosimulator.analyzer.completions.Completion;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.entity.ComposedProvidingRequiringEntity;
import org.palladiosimulator.pcm.parameter.VariableCharacterisation;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.subsystem.SubSystem;

@SuppressWarnings("all")
public class SimComposedStructureXpt extends ComposedStructureXpt {
  @Inject
  @Extension
  private PCMext _pCMext;

  @Inject
  @Extension
  private JavaNamesExt _javaNamesExt;

  @Override
  public CharSequence childInitTM(final AssemblyContext ac, final ComposedStructure s) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("context.setUserData(this.myContext.getUserData());");
    _builder.newLine();
    _builder.append("  ");
    _builder.newLine();
    {
      RepositoryComponent _encapsulatedComponent__AssemblyContext = ac.getEncapsulatedComponent__AssemblyContext();
      if ((_encapsulatedComponent__AssemblyContext instanceof BasicComponent)) {
        _builder.append("//Initialize Component Parameters");
        _builder.newLine();
        _builder.append("de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object> componentStackFrame = ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("new de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object>();");
        _builder.newLine();
        {
          EList<VariableUsage> _configParameterUsages__AssemblyContext = ac.getConfigParameterUsages__AssemblyContext();
          for(final VariableUsage pu : _configParameterUsages__AssemblyContext) {
            {
              EList<VariableCharacterisation> _variableCharacterisation_VariableUsage = pu.getVariableCharacterisation_VariableUsage();
              for(final VariableCharacterisation vc : _variableCharacterisation_VariableUsage) {
                _builder.append("componentStackFrame.addValue(\"");
                String _parameterUsageLHS = this._pCMext.parameterUsageLHS(pu);
                String _plus = (_parameterUsageLHS + ".");
                String _string = vc.getType().toString();
                String _plus_1 = (_plus + _string);
                _builder.append(_plus_1);
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("   \t");
                _builder.append("new de.uka.ipd.sdq.simucomframework.variables.EvaluationProxy(\"");
                String _specificationString = this._javaNamesExt.specificationString(vc.getSpecification_VariableCharacterisation().getSpecification());
                _builder.append(_specificationString, "   \t");
                _builder.append("\",");
                _builder.newLineIfNotEmpty();
                _builder.append("   \t");
                _builder.append("new de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object>()));");
                _builder.newLine();
              }
            }
          }
        }
        _builder.newLine();
        _builder.append("// possibly overwrite some with user data if this AssemblyContext is meant");
        _builder.newLine();
        _builder.append("this.myContext.getUserData().overwriteParametersForAssemblyContext(my");
        String _javaName = this._javaNamesExt.javaName(ac);
        _builder.append(_javaName);
        _builder.append(".getAssemblyContext().getId(), componentStackFrame);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("my");
        String _javaName_1 = this._javaNamesExt.javaName(ac);
        _builder.append(_javaName_1);
        _builder.append(".setComponentFrame(componentStackFrame);");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  public CharSequence composedPREConstructorStart(final ComposedProvidingRequiringEntity cpre) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("private org.palladiosimulator.pcm.core.composition.AssemblyContext assemblyContext = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("public org.palladiosimulator.pcm.core.composition.AssemblyContext getAssemblyContext() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return this.assemblyContext;");
    _builder.newLine();
    _builder.append("}\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private de.uka.ipd.sdq.simucomframework.model.SimuComModel model;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private de.uka.ipd.sdq.simucomframework.model.SimuComModel getModel() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return model;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      if ((cpre instanceof org.palladiosimulator.pcm.system.System)) {
        _builder.append("public ");
        String _className = this._javaNamesExt.className(cpre);
        _builder.append(_className);
        _builder.append("(de.uka.ipd.sdq.simucomframework.model.SimuComModel model) {");
        _builder.newLineIfNotEmpty();
        _builder.append("this.model = model; ");
        _builder.newLine();
      } else {
        _builder.append("public ");
        String _className_1 = this._javaNamesExt.className(cpre);
        _builder.append(_className_1);
        _builder.append(" (String completeAssemblyContextID, String assemblyContextURI, de.uka.ipd.sdq.simucomframework.model.SimuComModel model) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t    ");
        _builder.append("this.assemblyContext = (org.palladiosimulator.pcm.core.composition.AssemblyContext) org.palladiosimulator.commons.emfutils.EMFLoadHelper.loadAndResolveEObject(assemblyContextURI);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.newLine();
        _builder.append("this.model = model;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("logger.info(\"Creating composed structure ");
        String _entityName = cpre.getEntityName();
        _builder.append(_entityName);
        _builder.append(" with AssemblyContextID \" + assemblyContext.getId());");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }

  private CharSequence childMemberVarInit(final AssemblyContext ac) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("my");
    String _javaName = this._javaNamesExt.javaName(ac);
    _builder.append(_javaName);
    _builder.append(" = new ");
    String _fqn = this._javaNamesExt.fqn(ac.getEncapsulatedComponent__AssemblyContext());
    _builder.append(_fqn);
    _builder.newLineIfNotEmpty();
    _builder.append("      \t");
    _builder.append("(");
    CharSequence _componentConstructorParametersTM = this.componentConstructorParametersTM(ac);
    _builder.append(_componentConstructorParametersTM, "      \t");
    _builder.append(", model);");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Override
  public CharSequence composedPREConstructorStartTM(final ComposedProvidingRequiringEntity entity) {
    return this.composedPREConstructorStart(entity);
  }

  @Override
  public CharSequence componentConstructorParametersTM(final AssemblyContext obj) {
    CharSequence _xifexpression = null;
    if ((((obj.getParentStructure__AssemblyContext() instanceof CompositeComponent) || (obj.getParentStructure__AssemblyContext() instanceof SubSystem)) || (obj.getParentStructure__AssemblyContext() instanceof Completion))) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("\"");
      String _id = obj.getId();
      _builder.append(_id);
      _builder.append("\" + completeAssemblyContextID, \"");
      URI _uRI = obj.eResource().getURI();
      String _plus = (_uRI + "#");
      String _id_1 = obj.getId();
      String _plus_1 = (_plus + _id_1);
      _builder.append(_plus_1);
      _builder.append("\"");
      _xifexpression = _builder;
    } else {
      CharSequence _xifexpression_1 = null;
      ComposedStructure _parentStructure__AssemblyContext = obj.getParentStructure__AssemblyContext();
      if ((_parentStructure__AssemblyContext instanceof org.palladiosimulator.pcm.system.System)) {
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("\"");
        String _id_2 = obj.getId();
        _builder_1.append(_id_2);
        _builder_1.append("\", \"");
        URI _uRI_1 = obj.eResource().getURI();
        String _plus_2 = (_uRI_1 + "#");
        String _id_3 = obj.getId();
        String _plus_3 = (_plus_2 + _id_3);
        _builder_1.append(_plus_3);
        _builder_1.append("\"");
        _xifexpression_1 = _builder_1;
      } else {
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("this.assemblyContext");
        _xifexpression_1 = _builder_2;
      }
      _xifexpression = _xifexpression_1;
    }
    return _xifexpression;
  }

  @Override
  public CharSequence childMemberVarInitTM(final AssemblyContext context) {
    return this.childMemberVarInit(context);
  }

  @Override
  public CharSequence composedStructureEnd(final ComposedStructure entity) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
