/**
 */
package org.palladiosimulator.simulizar.action.core.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.palladiosimulator.simulizar.action.core.util.CoreAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class CoreItemProviderAdapterFactory extends CoreAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CoreItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.simulizar.action.core.AdaptationBehaviorRepository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AdaptationBehaviorRepositoryItemProvider adaptationBehaviorRepositoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.simulizar.action.core.AdaptationBehaviorRepository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAdaptationBehaviorRepositoryAdapter() {
		if (adaptationBehaviorRepositoryItemProvider == null) {
			adaptationBehaviorRepositoryItemProvider = new AdaptationBehaviorRepositoryItemProvider(this);
		}

		return adaptationBehaviorRepositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.simulizar.action.core.AdaptationBehavior} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AdaptationBehaviorItemProvider adaptationBehaviorItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.simulizar.action.core.AdaptationBehavior}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAdaptationBehaviorAdapter() {
		if (adaptationBehaviorItemProvider == null) {
			adaptationBehaviorItemProvider = new AdaptationBehaviorItemProvider(this);
		}

		return adaptationBehaviorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.simulizar.action.core.NestedAdaptationBehavior} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NestedAdaptationBehaviorItemProvider nestedAdaptationBehaviorItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.simulizar.action.core.NestedAdaptationBehavior}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNestedAdaptationBehaviorAdapter() {
		if (nestedAdaptationBehaviorItemProvider == null) {
			nestedAdaptationBehaviorItemProvider = new NestedAdaptationBehaviorItemProvider(this);
		}

		return nestedAdaptationBehaviorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.simulizar.action.core.StateTransformingStep} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateTransformingStepItemProvider stateTransformingStepItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.simulizar.action.core.StateTransformingStep}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateTransformingStepAdapter() {
		if (stateTransformingStepItemProvider == null) {
			stateTransformingStepItemProvider = new StateTransformingStepItemProvider(this);
		}

		return stateTransformingStepItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.simulizar.action.core.EnactAdaptationStep} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnactAdaptationStepItemProvider enactAdaptationStepItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.simulizar.action.core.EnactAdaptationStep}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnactAdaptationStepAdapter() {
		if (enactAdaptationStepItemProvider == null) {
			enactAdaptationStepItemProvider = new EnactAdaptationStepItemProvider(this);
		}

		return enactAdaptationStepItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.simulizar.action.core.ResourceDemandingStep} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResourceDemandingStepItemProvider resourceDemandingStepItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.simulizar.action.core.ResourceDemandingStep}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResourceDemandingStepAdapter() {
		if (resourceDemandingStepItemProvider == null) {
			resourceDemandingStepItemProvider = new ResourceDemandingStepItemProvider(this);
		}

		return resourceDemandingStepItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.simulizar.action.core.GuardedStep} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GuardedStepItemProvider guardedStepItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.simulizar.action.core.GuardedStep}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGuardedStepAdapter() {
		if (guardedStepItemProvider == null) {
			guardedStepItemProvider = new GuardedStepItemProvider(this);
		}

		return guardedStepItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.simulizar.action.core.GuardedTransition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GuardedTransitionItemProvider guardedTransitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.simulizar.action.core.GuardedTransition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGuardedTransitionAdapter() {
		if (guardedTransitionItemProvider == null) {
			guardedTransitionItemProvider = new GuardedTransitionItemProvider(this);
		}

		return guardedTransitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.simulizar.action.core.RoleType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RoleTypeItemProvider roleTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.simulizar.action.core.RoleType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRoleTypeAdapter() {
		if (roleTypeItemProvider == null) {
			roleTypeItemProvider = new RoleTypeItemProvider(this);
		}

		return roleTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.palladiosimulator.simulizar.action.core.ControllerCall} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ControllerCallItemProvider controllerCallItemProvider;

	/**
	 * This creates an adapter for a {@link org.palladiosimulator.simulizar.action.core.ControllerCall}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createControllerCallAdapter() {
		if (controllerCallItemProvider == null) {
			controllerCallItemProvider = new ControllerCallItemProvider(this);
		}

		return controllerCallItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (adaptationBehaviorRepositoryItemProvider != null)
			adaptationBehaviorRepositoryItemProvider.dispose();
		if (adaptationBehaviorItemProvider != null)
			adaptationBehaviorItemProvider.dispose();
		if (nestedAdaptationBehaviorItemProvider != null)
			nestedAdaptationBehaviorItemProvider.dispose();
		if (stateTransformingStepItemProvider != null)
			stateTransformingStepItemProvider.dispose();
		if (enactAdaptationStepItemProvider != null)
			enactAdaptationStepItemProvider.dispose();
		if (resourceDemandingStepItemProvider != null)
			resourceDemandingStepItemProvider.dispose();
		if (guardedStepItemProvider != null)
			guardedStepItemProvider.dispose();
		if (guardedTransitionItemProvider != null)
			guardedTransitionItemProvider.dispose();
		if (roleTypeItemProvider != null)
			roleTypeItemProvider.dispose();
		if (controllerCallItemProvider != null)
			controllerCallItemProvider.dispose();
	}

}
