/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.action.interpreter;

import de.uka.ipd.sdq.scheduler.resources.active.IResourceTableManager;
import java.util.Objects;
import java.util.Optional;
import org.palladiosimulator.simulizar.action.context.ExecutionContext;
import org.palladiosimulator.simulizar.action.core.AdaptationBehaviorRepository;
import org.palladiosimulator.simulizar.action.instance.RoleSet;
import org.palladiosimulator.simulizar.action.interpreter.TransientEffectInterpreter;
import org.palladiosimulator.simulizar.action.parameter.ControllerCallInputVariableUsageCollection;
import org.palladiosimulator.simulizar.action.parameter.ParameterFactory;
import org.palladiosimulator.simulizar.runtimestate.IRuntimeStateAccessor;
import org.palladiosimulator.simulizar.runtimestate.SimuLizarRuntimeState;

public class ActionRuntimeState
implements IRuntimeStateAccessor {
    private static SimuLizarRuntimeState state;
    private static final ControllerCallInputVariableUsageCollection EMPTY_VARIABLE_USAGE_COLLECTION;

    static {
        EMPTY_VARIABLE_USAGE_COLLECTION = ParameterFactory.eINSTANCE.createControllerCallInputVariableUsageCollection();
    }

    public static TransientEffectInterpreterBuilder getInterpreterBuilder(RoleSet roleSet, AdaptationBehaviorRepository repository) {
        return new TransientEffectInterpreterBuilder(roleSet, repository);
    }

    public void setRuntimeStateModel(SimuLizarRuntimeState passedState) {
        state = Objects.requireNonNull(passedState);
    }

    public static class TransientEffectInterpreterBuilder {
        private final SimuLizarRuntimeState state = state;
        private final RoleSet roleSet;
        private final AdaptationBehaviorRepository repository;
        private ExecutionContext context = null;
        private ControllerCallInputVariableUsageCollection controllerCallVariableUsages = EMPTY_VARIABLE_USAGE_COLLECTION;
        private boolean isAsync = false;

        private TransientEffectInterpreterBuilder(RoleSet roleSet, AdaptationBehaviorRepository repository) {
            this.roleSet = Objects.requireNonNull(roleSet);
            this.repository = Objects.requireNonNull(repository);
        }

        public TransientEffectInterpreterBuilder isAsync() {
            this.isAsync = true;
            return this;
        }

        public TransientEffectInterpreterBuilder isAsync(ExecutionContext context) {
            return this.isAsync().addExecutionContext(Objects.requireNonNull(context));
        }

        public TransientEffectInterpreterBuilder addControllerCallVariableUsages(ControllerCallInputVariableUsageCollection controllerCallVariabelUsages) {
            this.controllerCallVariableUsages = Objects.requireNonNull(controllerCallVariabelUsages);
            return this;
        }

        public TransientEffectInterpreterBuilder addExecutionContext(ExecutionContext executionContext) {
            this.context = Objects.requireNonNull(executionContext);
            return this;
        }

        public TransientEffectInterpreter build(IResourceTableManager resourceTableManager) {
            return new TransientEffectInterpreter(this.state, this.roleSet, this.controllerCallVariableUsages, this.repository, this.isAsync, Optional.ofNullable(this.context), resourceTableManager);
        }
    }
}

