/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulizar.aggregation.aggregators;

import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.monitorrepository.MeasurementDrivenAggregation;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.monitorrepository.VariableSizeAggregation;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulizar.aggregation.aggregators.AbstractMeasurementAggregator;

public class VariableSizeMeasurementAggregator
extends AbstractMeasurementAggregator {
    private final Deque<MeasuringValue> buffer = new LinkedList<MeasuringValue>();
    private final VariableSizeAggregation variableSizeAggregation;
    private final Amount<Duration> retrospectionLength;
    private static final Amount<Duration> ZERO_DURATION = Amount.valueOf((long)0L, (Unit)Duration.UNIT);

    public VariableSizeMeasurementAggregator(NumericalBaseMetricDescription expectedMetric, RuntimeMeasurementModel runtimeMeasurementModel, VariableSizeAggregation variableSizeAggregation) {
        super(Objects.requireNonNull(expectedMetric), Objects.requireNonNull(runtimeMeasurementModel), (MeasurementDrivenAggregation)Objects.requireNonNull(variableSizeAggregation));
        this.variableSizeAggregation = variableSizeAggregation;
        Measure retrospectionMeasure = this.variableSizeAggregation.getRetrospectionLengthAsMeasure();
        if (retrospectionMeasure.compareTo(ZERO_DURATION) <= 0) {
            throw new IllegalStateException("Value of '" + MonitorRepositoryPackage.Literals.VARIABLE_SIZE_AGGREGATION__RETROSPECTION_LENGTH.getName() + "' attribute of '" + variableSizeAggregation.eClass().getName() + "' with id " + variableSizeAggregation.getId() + " must be positive!");
        }
        this.retrospectionLength = Amount.valueOf((double)((Double)retrospectionMeasure.getValue()), (Unit)retrospectionMeasure.getUnit());
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @Override
    protected boolean aggregationRequired() {
        return !this.buffer.isEmpty() && !VariableSizeMeasurementAggregator.getPointInTimeOfMeasurement(this.buffer.getLast()).minus(this.retrospectionLength).isLessThan(VariableSizeMeasurementAggregator.getPointInTimeOfMeasurement(this.buffer.getFirst()));
    }

    @Override
    protected Amount<Duration> getIntervalStartTime() {
        Amount result = this.getIntervalEndTime().minus(this.retrospectionLength);
        return result.compareTo(ZERO_DURATION) < 0 ? ZERO_DURATION : result;
    }

    @Override
    protected Amount<Duration> getIntervalEndTime() {
        return VariableSizeMeasurementAggregator.getPointInTimeOfMeasurement(this.buffer.getLast());
    }

    @Override
    protected Iterable<MeasuringValue> getDataToAggregate() {
        return Collections.unmodifiableCollection(this.buffer);
    }

    @Override
    protected void collectMeasurement(MeasuringValue newMeasurement) {
        this.buffer.add(newMeasurement);
    }

    private void evictMeasurements() {
        switch (this.getExpectedMetric().getScopeOfValidity()) {
            case CONTINUOUS: {
                MeasuringValue first = this.buffer.peekFirst();
                MeasuringValue lastPolled = null;
                while (first != null && VariableSizeMeasurementAggregator.getPointInTimeOfMeasurement(this.buffer.getLast()).minus(VariableSizeMeasurementAggregator.getPointInTimeOfMeasurement(first)).isGreaterThan(this.retrospectionLength)) {
                    lastPolled = this.buffer.pollFirst();
                    first = this.buffer.peekFirst();
                }
                if (lastPolled == null) break;
                this.buffer.addFirst(lastPolled);
                break;
            }
            case DISCRETE: {
                while (!this.buffer.isEmpty() && VariableSizeMeasurementAggregator.getPointInTimeOfMeasurement(this.buffer.getLast()).minus(VariableSizeMeasurementAggregator.getPointInTimeOfMeasurement(this.buffer.getFirst())).isGreaterThan(this.retrospectionLength)) {
                    this.buffer.pollFirst();
                }
                break;
            }
            default: {
                throw new AssertionError((Object)"Should not be reached!");
            }
        }
    }

    @Override
    protected void onPreAggregate() {
        this.evictMeasurements();
    }
}

