/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulizar.aggregation.probeframework;

import java.util.Optional;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSpecPackage;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.metricspec.util.MetricSpecSwitch;
import org.palladiosimulator.monitorrepository.FixedSizeAggregation;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.monitorrepository.VariableSizeAggregation;
import org.palladiosimulator.probeframework.calculator.IObservableCalculatorRegistry;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementPackage;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractProbeFrameworkListener;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractRecordingProbeFrameworkListenerDecorator;
import org.palladiosimulator.simulizar.interpreter.listener.DeferredMeasurementInitialization;
import org.palladiosimulizar.aggregation.aggregators.FixedSizeMeasurementsAggregator;
import org.palladiosimulizar.aggregation.aggregators.VariableSizeMeasurementAggregator;

public class AggregatorsProbeFrameworkListenerDecorator
extends AbstractRecordingProbeFrameworkListenerDecorator {
    private static final EClass FIXED_SIZE_AGGREGATION_ECLASS = MonitorRepositoryPackage.Literals.FIXED_SIZE_AGGREGATION;
    private static final EClass VARIABLE_SIZE_AGGREGATION_ECLASS = MonitorRepositoryPackage.Literals.VARIABLE_SIZE_AGGREGATION;
    private IObservableCalculatorRegistry calculatorRegistry;
    private RuntimeMeasurementModel runtimeMeasurementModel;
    private static final MetricSpecSwitch<Optional<NumericalBaseMetricDescription>> GET_NUMERICAL_BASE_METRIC_SWITCH = new MetricSpecSwitch<Optional<NumericalBaseMetricDescription>>(){

        public Optional<NumericalBaseMetricDescription> caseNumericalBaseMetricDescription(NumericalBaseMetricDescription numericalBaseMetricDescription) {
            return Optional.of(numericalBaseMetricDescription);
        }

        public Optional<NumericalBaseMetricDescription> defaultCase(EObject eObject) {
            return Optional.empty();
        }
    };

    public void setProbeFrameworkListener(AbstractProbeFrameworkListener listener) {
        super.setProbeFrameworkListener(listener);
        this.calculatorRegistry = this.getProbeFrameworkContext().getCalculatorRegistry();
        PCMPartitionManager manager = this.getProbeFrameworkListener().getPCMPartitionManager();
        this.runtimeMeasurementModel = (RuntimeMeasurementModel)manager.findModel(RuntimeMeasurementPackage.eINSTANCE.getRuntimeMeasurementModel());
    }

    public void registerMeasurements() {
        super.registerMeasurements();
        this.getProbeFrameworkListener().getMeasurementSpecificationsForProcessingType(FIXED_SIZE_AGGREGATION_ECLASS).stream().filter(MeasurementSpecification::isTriggersSelfAdaptations).forEach(this::initFixedSizeAggregation);
        this.getProbeFrameworkListener().getMeasurementSpecificationsForProcessingType(VARIABLE_SIZE_AGGREGATION_ECLASS).stream().filter(MeasurementSpecification::isTriggersSelfAdaptations).forEach(this::initVariableSizeAggregation);
    }

    private void initVariableSizeAggregation(MeasurementSpecification measurementSpecification) {
        MeasuringPoint measuringPoint = measurementSpecification.getMonitor().getMeasuringPoint();
        Optional expectedMetric = (Optional)GET_NUMERICAL_BASE_METRIC_SWITCH.doSwitch((EObject)measurementSpecification.getMetricDescription());
        AggregatorsProbeFrameworkListenerDecorator.checkValidity(expectedMetric, measurementSpecification);
        DeferredMeasurementInitialization.forCalculatorFactoryDecorator((IObservableCalculatorRegistry)this.calculatorRegistry).onMetricDescriptionAndMeasuringPoint((MetricDescription)expectedMetric.get(), measuringPoint, () -> new VariableSizeMeasurementAggregator((NumericalBaseMetricDescription)expectedMetric.get(), this.runtimeMeasurementModel, (VariableSizeAggregation)measurementSpecification.getProcessingType()));
    }

    private void initFixedSizeAggregation(MeasurementSpecification measurementSpecification) {
        MeasuringPoint measuringPoint = measurementSpecification.getMonitor().getMeasuringPoint();
        Optional expectedMetric = (Optional)GET_NUMERICAL_BASE_METRIC_SWITCH.doSwitch((EObject)measurementSpecification.getMetricDescription());
        AggregatorsProbeFrameworkListenerDecorator.checkValidity(expectedMetric, measurementSpecification);
        DeferredMeasurementInitialization.forCalculatorFactoryDecorator((IObservableCalculatorRegistry)this.calculatorRegistry).onMetricDescriptionAndMeasuringPoint((MetricDescription)expectedMetric.get(), measuringPoint, () -> new FixedSizeMeasurementsAggregator((NumericalBaseMetricDescription)expectedMetric.get(), this.runtimeMeasurementModel, (FixedSizeAggregation)measurementSpecification.getProcessingType()));
    }

    private static void checkValidity(Optional<NumericalBaseMetricDescription> expectedMetric, MeasurementSpecification spec) {
        if (!expectedMetric.isPresent()) {
            throw new IllegalStateException("Cannot initialize measurements aggregation defined by " + spec.eClass().getName() + " with id '" + spec.getId() + "':\nSo far, only " + MetricSpecPackage.Literals.NUMERICAL_BASE_METRIC_DESCRIPTION.getName() + "s are supported for fixed and variable size aggregation!");
        }
    }
}

