/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.core.utils;

import de.uka.ipd.sdq.stoex.StoexPackage;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Qualifier;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.commons.emfutils.EMFCopyHelper;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.pcm.PcmPackage;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementFactory;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.simulizar.core.runconfig.SimuLizarWorkflowConfiguration;

public class PCMPartitionManager {
    private static final Logger LOGGER = Logger.getLogger((String)PCMPartitionManager.class.getName());
    private static final String RM_MODEL_FILE_EXTENSION = ".runtimemeasurement";
    private final PCMResourceSetPartition globalPartition;
    private final MDSDBlackboard blackboard;
    private boolean isObservingPcmChanges = false;
    private PCMResourceSetPartition currentPartition;
    private boolean modelsDirty = false;
    private final Adapter globalPCMChangeListener = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (this.isPCMModel(notification.getFeature()) && notification.getEventType() != 8) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Detected change in global PCM model. Changed object: " + notification.getNotifier()));
                    LOGGER.debug((Object)notification.toString());
                }
                PCMPartitionManager.this.modelsDirty = true;
            }
        }

        private boolean isPCMModel(Object feature) {
            EStructuralFeature eStructFeature;
            EClass containingClass;
            EObject rootContainer;
            return EcorePackage.eINSTANCE.getEObject().isInstance(feature) && EcorePackage.eINSTANCE.getEStructuralFeature().isInstance(feature) && (PcmPackage.eINSTANCE == (rootContainer = EcoreUtil.getRootContainer((EObject)(containingClass = (eStructFeature = (EStructuralFeature)feature).getEContainingClass()))) || StoexPackage.eINSTANCE == rootContainer);
        }
    };

    public PCMPartitionManager(MDSDBlackboard blackboard, SimuLizarWorkflowConfiguration config) {
        this.blackboard = blackboard;
        this.globalPartition = (PCMResourceSetPartition)blackboard.getPartition("org.palladiosimulator.pcmmodels.partition");
        if (this.globalPartition == null) {
            throw new IllegalStateException("The provided blackboard does not contain the required PCM partition");
        }
        this.currentPartition = this.copyPCMPartition();
    }

    public void initialize() {
        Optional result = this.globalPartition.getElement(MonitorRepositoryPackage.Literals.MONITOR_REPOSITORY).stream().findAny();
        if (result.isPresent()) {
            URI uri = ((EObject)result.get()).eResource().getURI().appendFileExtension(RM_MODEL_FILE_EXTENSION);
            Resource resource = this.globalPartition.getResourceSet().createResource(uri);
            resource.getContents().add((Object)RuntimeMeasurementFactory.eINSTANCE.createRuntimeMeasurementModel());
        } else {
            LOGGER.error((Object)"No monitor repository set in global partition.");
        }
    }

    public PCMResourceSetPartition getGlobalPCMModel() {
        return this.globalPartition;
    }

    public PCMResourceSetPartition getLocalPCMModel() {
        this.checkAndHandleDeferredChanges();
        return this.currentPartition;
    }

    private void checkAndHandleDeferredChanges() {
        if (this.modelsDirty) {
            this.currentPartition = this.copyPCMPartition();
            this.modelsDirty = false;
        }
    }

    private PCMResourceSetPartition copyPCMPartition() {
        LOGGER.debug((Object)"Take a new copy of the global PCM for new simulation threads");
        PCMResourceSetPartition newPartition = new PCMResourceSetPartition();
        List modelCopy = EMFCopyHelper.deepCopyToEObjectList((ResourceSet)this.globalPartition.getResourceSet());
        int i = 0;
        while (i < modelCopy.size()) {
            Resource resource = newPartition.getResourceSet().createResource(URI.createFileURI((String)("/temp" + i)));
            resource.getContents().add((Object)((EObject)modelCopy.get(i)));
            ++i;
        }
        return newPartition;
    }

    public void startObservingPcmChanges() {
        if (!this.isObservingPcmChanges) {
            this.filterResourcesToListen().forEach(resource -> this.addListenerTo((Resource)resource));
            this.isObservingPcmChanges = true;
        }
    }

    public void stopObservingPcmChanges() {
        if (this.isObservingPcmChanges) {
            this.filterResourcesToListen().forEach(resource -> this.removeListenerFrom((Resource)resource));
            this.isObservingPcmChanges = false;
        }
    }

    private List<Resource> filterResourcesToListen() {
        Stream resources = this.globalPartition.getResourceSet().getResources().stream();
        return resources.filter(this.resourcesToListen()).collect(Collectors.toList());
    }

    private Predicate<Resource> resourcesToListen() {
        return r -> {
            if (r.getContents().isEmpty()) {
                return false;
            }
            return !(r.getContents().get(0) instanceof RuntimeMeasurementModel);
        };
    }

    private void addListenerTo(Resource resource) {
        EList adapters = resource.eAdapters();
        if (!adapters.contains(this.globalPCMChangeListener)) {
            adapters.add(this.globalPCMChangeListener);
        }
    }

    private void removeListenerFrom(Resource resource) {
        resource.eAdapters().remove((Object)this.globalPCMChangeListener);
    }

    public <T extends EObject> T findModel(EClass targetType) {
        List result = this.globalPartition.getElement(targetType);
        if (result.isEmpty()) {
            LOGGER.info((Object)String.format("No model with target type %s was found.", targetType));
            return null;
        }
        return (T)((EObject)result.get(0));
    }

    public MDSDBlackboard getBlackboard() {
        return this.blackboard;
    }

    @Qualifier
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Global {
    }

    @Qualifier
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Local {
    }
}

