/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.monitorrepository.map.probeframework;

import java.util.Objects;
import org.eclipse.emf.ecore.EClass;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.map.Map;
import org.palladiosimulator.monitorrepository.map.MapPackage;
import org.palladiosimulator.probeframework.calculator.IObservableCalculatorRegistry;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementPackage;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractProbeFrameworkListener;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractRecordingProbeFrameworkListenerDecorator;
import org.palladiosimulator.simulizar.interpreter.listener.DeferredMeasurementInitialization;
import org.palladiosimulator.simulizar.monitorrepository.map.runtimemeasurement.MonitorRepositoryMapRuntimeMeasurementsRecorder;

public class MonitorRepositoryMapProbeFrameworkListenerDecorator
extends AbstractRecordingProbeFrameworkListenerDecorator {
    private static final EClass MAP_PROCESSING_TYPE = MapPackage.Literals.MAP;
    private RuntimeMeasurementModel rmModel = null;
    private IObservableCalculatorRegistry calculatorRegistry;

    public void setProbeFrameworkListener(AbstractProbeFrameworkListener probeFrameworkListener) {
        super.setProbeFrameworkListener(Objects.requireNonNull(probeFrameworkListener));
        PCMPartitionManager manager = this.getProbeFrameworkListener().getPCMPartitionManager();
        this.rmModel = (RuntimeMeasurementModel)manager.findModel(RuntimeMeasurementPackage.eINSTANCE.getRuntimeMeasurementModel());
        this.calculatorRegistry = this.getProbeFrameworkContext().getCalculatorRegistry();
    }

    public void registerMeasurements() {
        super.registerMeasurements();
        this.getProbeFrameworkListener().getMeasurementSpecificationsForProcessingType(MAP_PROCESSING_TYPE).stream().filter(MeasurementSpecification::isTriggersSelfAdaptations).forEach(this::initMapping);
    }

    private void initMapping(MeasurementSpecification measurementSpecification) {
        MetricDescription metric = measurementSpecification.getMetricDescription();
        MeasuringPoint measuringPoint = measurementSpecification.getMonitor().getMeasuringPoint();
        DeferredMeasurementInitialization.forCalculatorFactoryDecorator((IObservableCalculatorRegistry)this.calculatorRegistry).onMetricDescriptionAndMeasuringPoint(metric, measuringPoint, () -> new MonitorRepositoryMapRuntimeMeasurementsRecorder(this.rmModel, (Map)measurementSpecification.getProcessingType()));
    }
}

