/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.monitorrepository.map.runtimemeasurement;

import java.util.Objects;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSpecPackage;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.monitorrepository.map.Map;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementPackage;
import org.palladiosimulator.simulizar.metrics.PRMRecorder;

public class MonitorRepositoryMapRuntimeMeasurementsRecorder
extends PRMRecorder
implements IMeasurementSourceListener {
    private final Map mapProcessingType;
    private final MetricDescription expectedInputMetric;
    private final NumericalBaseMetricDescription expectedOutputMetric;
    private final Unit<Quantity> defaultOutputUnit;
    private final boolean expectsBaseMetric;

    public MonitorRepositoryMapRuntimeMeasurementsRecorder(RuntimeMeasurementModel rmModel, Map mapProcessingType) {
        super(Objects.requireNonNull(rmModel), Objects.requireNonNull(mapProcessingType).getMeasurementSpecification());
        this.mapProcessingType = mapProcessingType;
        this.expectedInputMetric = this.getMeasurementSpecification().getMetricDescription();
        this.expectsBaseMetric = MetricSpecPackage.Literals.BASE_METRIC_DESCRIPTION.isInstance((Object)this.expectedInputMetric);
        if (!MetricSpecPackage.Literals.NUMERICAL_BASE_METRIC_DESCRIPTION.isInstance((Object)this.mapProcessingType.getOutputMetricDescription())) {
            throw new IllegalStateException("So far, only numerical values can be forwarded to " + RuntimeMeasurementPackage.Literals.RUNTIME_MEASUREMENT_MODEL.getName() + "s. Hence, the output metric of the measurement mapping ' " + mapProcessingType.getEntityName() + "' (id: " + mapProcessingType.getId() + ") must be a " + MetricSpecPackage.Literals.NUMERICAL_BASE_METRIC_DESCRIPTION.getName());
        }
        this.expectedOutputMetric = (NumericalBaseMetricDescription)this.mapProcessingType.getOutputMetricDescription();
        this.defaultOutputUnit = this.expectedOutputMetric.getDefaultUnit();
    }

    public void newMeasurementAvailable(MeasuringValue newMeasurement) {
        if (!(Objects.requireNonNull(newMeasurement).isCompatibleWith(this.expectedInputMetric) || this.expectsBaseMetric && MetricDescriptionUtility.isBaseMetricDescriptionSubsumedByMetricDescription((BaseMetricDescription)((BaseMetricDescription)this.expectedInputMetric), (MetricDescription)newMeasurement.getMetricDesciption()))) {
            throw new IllegalStateException("Somehow a wrong measurement kind was passed.");
        }
        MeasuringValue transformedMeasurement = this.mapProcessingType.apply(newMeasurement);
        super.updateMeasurementValue(transformedMeasurement.getMeasureForMetric((MetricDescription)this.expectedOutputMetric).doubleValue(this.defaultOutputUnit));
    }

    public void preUnregister() {
        this.detachFromPRM();
    }
}

