/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.henshin;

import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.model.Module;
import org.palladiosimulator.simulizar.reconfiguration.AbstractReconfigurationLoader;
import org.palladiosimulator.simulizar.reconfiguration.henshin.HenshinModelTransformation;
import org.palladiosimulator.simulizar.reconfigurationrule.ModelTransformation;

public class HenshinReconfigurationLoader
extends AbstractReconfigurationLoader {
    private static final String HENSHIN_FILE_EXTENSION = ".henshin";

    protected String getTransformationFileExtension() {
        return HENSHIN_FILE_EXTENSION;
    }

    protected void setTransformations(URI[] transURIs) {
        URI[] uRIArray = transURIs;
        int n = transURIs.length;
        int n2 = 0;
        while (n2 < n) {
            URI each = uRIArray[n2];
            Optional<HenshinModelTransformation> trans = this.toHenshinModelTransformation(each);
            if (trans.isPresent()) {
                this.transformations.add((ModelTransformation)trans.get());
            }
            ++n2;
        }
    }

    private Optional<HenshinModelTransformation> toHenshinModelTransformation(URI henshinURI) {
        ResourceSetImpl rsHelper = new ResourceSetImpl();
        for (EObject each : rsHelper.getResource(henshinURI, true).getContents()) {
            if (!(each instanceof Module)) continue;
            return Optional.of(new HenshinModelTransformation((Module)each));
        }
        return Optional.empty();
    }
}

