/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.qvto.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.simulizar.reconfiguration.qvto.QvtoModelTransformation;
import org.palladiosimulator.simulizar.reconfiguration.qvto.util.ModelTransformationFactory;

public class ModelTransformationCache {
    private final Map<URI, QvtoModelTransformation> cache = new HashMap<URI, QvtoModelTransformation>();
    private final ModelTransformationFactory modelTransformationFactory = new ModelTransformationFactory();
    private static final Logger LOGGER = Logger.getLogger(ModelTransformationCache.class);

    @SafeVarargs
    public ModelTransformationCache(URI ... initialTransformations) {
        this.store(initialTransformations);
    }

    @SafeVarargs
    public final void store(URI ... transformationUris) {
        URI[] uris;
        URI[] uRIArray = uris = Objects.requireNonNull(transformationUris);
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI transformationUri = uRIArray[n2];
            if (this.contains(transformationUri)) {
                throw new IllegalArgumentException("Transformation " + transformationUri + " already in store.");
            }
            LOGGER.debug((Object)("Cache reconfiguration rule \"" + transformationUri + "\""));
            this.cache.put(transformationUri, this.modelTransformationFactory.createModelTransformation(transformationUri));
            ++n2;
        }
    }

    public Optional<QvtoModelTransformation> get(URI transformationUri) {
        if (!this.contains(transformationUri)) {
            this.store(transformationUri);
        }
        return Optional.ofNullable(this.cache.get(Objects.requireNonNull(transformationUri)));
    }

    @SafeVarargs
    public final void remove(URI ... transformationUris) {
        URI[] uris = Objects.requireNonNull(transformationUris);
        Arrays.stream(uris).map(Objects::requireNonNull).forEach(this.cache::remove);
    }

    public boolean contains(URI transformationUri) {
        return this.cache.containsKey(Objects.requireNonNull(transformationUri));
    }

    public Iterable<QvtoModelTransformation> getAll() {
        return this.cache.values();
    }

    public void clear() {
        this.cache.clear();
    }
}

