/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.slidingwindow.probeframework;

import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import java.util.Collection;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import org.eclipse.emf.ecore.EClass;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.experimentanalysis.DiscardAllElementsPriorToLowerBoundStrategy;
import org.palladiosimulator.experimentanalysis.ISlidingWindowListener;
import org.palladiosimulator.experimentanalysis.ISlidingWindowMoveOnStrategy;
import org.palladiosimulator.experimentanalysis.KeepLastElementPriorToLowerBoundStrategy;
import org.palladiosimulator.experimentanalysis.SlidingWindow;
import org.palladiosimulator.experimentanalysis.SlidingWindowRecorder;
import org.palladiosimulator.measurementframework.listener.MeasurementSource;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSpecPackage;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.monitorrepository.TimeDrivenAggregation;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.IObservableCalculatorRegistry;
import org.palladiosimulator.recorderframework.core.IRecorder;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementPackage;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractProbeFrameworkListener;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractRecordingProbeFrameworkListenerDecorator;
import org.palladiosimulator.simulizar.slidingwindow.aggregators.SlidingWindowStatisticalCharacterizationAggregator;
import org.palladiosimulator.simulizar.slidingwindow.impl.SimulizarSlidingWindow;
import org.palladiosimulator.simulizar.slidingwindow.runtimemeasurement.SlidingWindowRuntimeMeasurementsRecorder;

public class SlidingWindowProbeFrameWorkListenerDecorator
extends AbstractRecordingProbeFrameworkListenerDecorator {
    private static final EClass TIME_DRIVEN_AGGREGATION_ECLASS = MonitorRepositoryPackage.Literals.TIME_DRIVEN_AGGREGATION;
    private IObservableCalculatorRegistry calculatorRegistry;
    private SimuComModel model;
    private RuntimeMeasurementModel runtimeMeasurementModel;
    private ISlidingWindowMoveOnStrategy discreteMetricScopeStrategy = null;
    private ISlidingWindowMoveOnStrategy continuousMetricScopeStrategy = null;

    public void registerMeasurements() {
        super.registerMeasurements();
        this.initSlidingWindowBasedMeasurements();
    }

    public void setProbeFrameworkListener(AbstractProbeFrameworkListener listener) {
        super.setProbeFrameworkListener(listener);
        this.calculatorRegistry = this.getProbeFrameworkContext().getCalculatorRegistry();
        this.model = this.getProbeFrameworkListener().getSimuComModel();
        PCMPartitionManager manager = this.getProbeFrameworkListener().getPCMPartitionManager();
        this.runtimeMeasurementModel = (RuntimeMeasurementModel)manager.findModel(RuntimeMeasurementPackage.eINSTANCE.getRuntimeMeasurementModel());
    }

    private void initSlidingWindowBasedMeasurements() {
        assert (this.getProbeFrameworkListener() != null);
        Collection measurementSpecs = this.getProbeFrameworkListener().getMeasurementSpecificationsForProcessingType(TIME_DRIVEN_AGGREGATION_ECLASS);
        this.initTimeDrivenAggregators(measurementSpecs);
    }

    private void initTimeDrivenAggregators(Collection<MeasurementSpecification> measurementSpecs) {
        if (!measurementSpecs.isEmpty()) {
            this.discreteMetricScopeStrategy = new DiscardAllElementsPriorToLowerBoundStrategy();
            this.continuousMetricScopeStrategy = new KeepLastElementPriorToLowerBoundStrategy();
            measurementSpecs.forEach(this::initAggregatorForMeasSpec);
        }
    }

    private void initAggregatorForMeasSpec(MeasurementSpecification measurementSpec) {
        MeasuringPoint measuringPoint = measurementSpec.getMonitor().getMeasuringPoint();
        if (!MetricSpecPackage.Literals.NUMERICAL_BASE_METRIC_DESCRIPTION.isInstance((Object)measurementSpec.getMetricDescription())) {
            throw new IllegalStateException("Time driven aggregation of measurements (sliding window based) cannot be initialized:\nCurrently, only " + MetricSpecPackage.Literals.NUMERICAL_BASE_METRIC_DESCRIPTION.getName() + "s are supported!\n" + "MeasuringPoint '" + measuringPoint.getStringRepresentation() + "'\n" + "Affected Monitor: '" + measurementSpec.getMonitor().getEntityName() + "'");
        }
        NumericalBaseMetricDescription expectedMetric = (NumericalBaseMetricDescription)measurementSpec.getMetricDescription();
        Calculator calculator = this.calculatorRegistry.getCalculatorsForMeasuringPoint(measuringPoint).stream().filter(calc -> MetricDescriptionUtility.isBaseMetricDescriptionSubsumedByMetricDescription((BaseMetricDescription)expectedMetric, (MetricDescription)calc.getMetricDesciption())).findAny().orElseThrow(() -> new IllegalStateException("Time driven aggregation of measurements (sliding window based) cannot be initialized.\nNo '" + expectedMetric.getName() + "' calculator available for: " + "MeasuringPoint '" + measuringPoint.getStringRepresentation() + "'.\n" + "Affected Monitor: '" + measurementSpec.getMonitor().getEntityName() + "'\n" + "Ensure that measurement calculator has been created and registered within the ProbeFrameworkListener class!"));
        ISlidingWindowMoveOnStrategy moveOnStrategy = null;
        switch (expectedMetric.getScopeOfValidity()) {
            case CONTINUOUS: {
                moveOnStrategy = this.continuousMetricScopeStrategy;
                break;
            }
            case DISCRETE: {
                moveOnStrategy = this.discreteMetricScopeStrategy;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        TimeDrivenAggregation aggregation = (TimeDrivenAggregation)measurementSpec.getProcessingType();
        SimulizarSlidingWindow window = new SimulizarSlidingWindow((Measure<Double, Duration>)aggregation.getWindowLengthAsMeasure(), (Measure<Double, Duration>)aggregation.getWindowIncrementAsMeasure(), (MetricDescription)expectedMetric, moveOnStrategy, this.model);
        SlidingWindowStatisticalCharacterizationAggregator windowAggregator = new SlidingWindowStatisticalCharacterizationAggregator(aggregation.getStatisticalCharacterization().getAggregator(expectedMetric));
        if (measurementSpec.isTriggersSelfAdaptations()) {
            windowAggregator.addRecorder(new SlidingWindowRuntimeMeasurementsRecorder(this.runtimeMeasurementModel, measurementSpec, measuringPoint));
        }
        super.registerMeasurementsRecorder((MeasurementSource)calculator, (IRecorder)new SlidingWindowRecorder((SlidingWindow)window, (ISlidingWindowListener)windowAggregator));
    }
}

