/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.slidingwindow.impl;

import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEventFactory;
import de.uka.ipd.sdq.simulation.core.ISimulationListener;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.palladiosimulator.experimentanalysis.ISlidingWindowMoveOnStrategy;
import org.palladiosimulator.experimentanalysis.SlidingWindow;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.simulizar.simulationevents.PeriodicallyTriggeredSimulationEntity;

public class SimulizarSlidingWindow
extends SlidingWindow {
    private SimuComModel model;
    private PeriodicallyTriggeredSimulationEntity simulationEntity = null;
    private ISimulationListener simulationListener = null;

    public SimulizarSlidingWindow(Measure<Double, Duration> windowLength, MetricDescription acceptedMetrics, ISlidingWindowMoveOnStrategy moveOnStrategy, SimuComModel model) {
        this(windowLength, windowLength, acceptedMetrics, moveOnStrategy, model);
    }

    public SimulizarSlidingWindow(Measure<Double, Duration> windowLength, Measure<Double, Duration> increment, MetricDescription acceptedMetrics, ISlidingWindowMoveOnStrategy moveOnStrategy, SimuComModel model) {
        this(windowLength, increment, (Measure<Double, Duration>)Measure.valueOf((double)0.0, (Unit)SI.SECOND), acceptedMetrics, moveOnStrategy, model);
    }

    public SimulizarSlidingWindow(Measure<Double, Duration> windowLength, Measure<Double, Duration> increment, Measure<Double, Duration> initialLowerBound, MetricDescription acceptedMetrics, ISlidingWindowMoveOnStrategy moveOnStrategy, SimuComModel model) {
        super(windowLength, increment, initialLowerBound, acceptedMetrics, moveOnStrategy);
        if (model == null) {
            throw new IllegalArgumentException("Sliding window must be initialized with a valid SimComModel instance.");
        }
        this.model = model;
        this.initializeTriggeredSimulationEntity(model);
    }

    private void initializeTriggeredSimulationEntity(SimuComModel model) {
        this.simulationEntity = new PeriodicallyTriggeredSimulationEntity((ISimEventFactory)model.getSimEngineFactory(), this.getSpecifiedWindowLength().doubleValue((Unit)SI.SECOND), this.getIncrement().doubleValue((Unit)SI.SECOND)){

            protected void triggerInternal() {
                SimulizarSlidingWindow.this.onWindowFullEvent();
            }
        };
        this.simulationListener = new ISimulationListener(){

            public void simulationStop() {
                SimulizarSlidingWindow.this.onSimulationStop();
            }

            public void simulationStart() {
            }
        };
        model.getConfiguration().addListener(this.simulationListener);
    }

    private void onSimulationStop() {
        Measure<Double, Duration> effectiveWindowLength = this.getEffectiveWindowLength();
        if (Double.compare(effectiveWindowLength.doubleValue((Unit)SI.SECOND), 0.0) != 0) {
            this.onWindowFullEvent();
        }
    }

    public Measure<Double, Duration> getCurrentUpperBound() {
        double lowerBoundValue = (Double)this.getCurrentLowerBound().getValue();
        Unit unit = this.getCurrentLowerBound().getUnit();
        double upperBoundValue = Math.min(lowerBoundValue + this.getSpecifiedWindowLength().doubleValue(unit), this.model.getSimulationControl().getCurrentSimulationTime());
        return Measure.valueOf((double)upperBoundValue, (Unit)unit);
    }

    public Measure<Double, Duration> getEffectiveWindowLength() {
        Unit unit = this.getCurrentLowerBound().getUnit();
        return Measure.valueOf((double)(this.getCurrentUpperBound().doubleValue(unit) - (Double)this.getCurrentLowerBound().getValue()), (Unit)unit);
    }

    public void flushAndStopAggregation() {
        this.simulationEntity.stopScheduling();
        this.model.getConfiguration().getListeners().remove(this.simulationListener);
        this.onSimulationStop();
    }
}

