/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.slidingwindow.aggregators;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import javax.measure.unit.Unit;
import org.jscience.physics.amount.Amount;
import org.palladiosimulator.experimentanalysis.windowaggregators.SlidingWindowAggregator;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.monitorrepository.statisticalcharacterization.StatisticalCharacterizationAggregator;
import org.palladiosimulator.recorderframework.core.IRecorder;

public class SlidingWindowStatisticalCharacterizationAggregator
extends SlidingWindowAggregator {
    private final StatisticalCharacterizationAggregator aggregator;

    public SlidingWindowStatisticalCharacterizationAggregator(StatisticalCharacterizationAggregator aggregator) {
        this.aggregator = Objects.requireNonNull(aggregator);
    }

    public SlidingWindowStatisticalCharacterizationAggregator(IRecorder recorderToWriteInto, StatisticalCharacterizationAggregator aggregator) {
        super(recorderToWriteInto);
        this.aggregator = Objects.requireNonNull(aggregator);
    }

    public SlidingWindowStatisticalCharacterizationAggregator(Collection<IRecorder> recordersToWriteInto, StatisticalCharacterizationAggregator aggregator) {
        super(recordersToWriteInto);
        this.aggregator = Objects.requireNonNull(aggregator);
    }

    public final NumericalBaseMetricDescription getExpectedWindowDataMetric() {
        return this.aggregator.getDataMetric();
    }

    protected final MeasuringValue processWindowData(Iterable<MeasuringValue> windowData, Measure<Double, Duration> windowLeftBound, Measure<Double, Duration> windowLength) {
        Amount leftBound = Amount.valueOf((double)((Double)windowLeftBound.getValue()), (Unit)windowLeftBound.getUnit());
        Amount length = Amount.valueOf((double)((Double)windowLength.getValue()), (Unit)windowLength.getUnit());
        Amount rightBound = leftBound.plus(length);
        return this.aggregator.aggregateData(windowData, leftBound, rightBound, Optional.of(length));
    }
}

