/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.slidingwindow.utils;

import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import java.util.Objects;
import javax.measure.Measure;
import javax.measure.quantity.Duration;
import org.palladiosimulator.experimentanalysis.DiscardAllElementsPriorToLowerBoundStrategy;
import org.palladiosimulator.experimentanalysis.ISlidingWindowListener;
import org.palladiosimulator.experimentanalysis.ISlidingWindowMoveOnStrategy;
import org.palladiosimulator.experimentanalysis.KeepLastElementPriorToLowerBoundStrategy;
import org.palladiosimulator.experimentanalysis.SlidingWindow;
import org.palladiosimulator.experimentanalysis.SlidingWindowRecorder;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSpecPackage;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.monitorrepository.TimeDrivenAggregation;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.simulizar.slidingwindow.aggregators.SlidingWindowStatisticalCharacterizationAggregator;
import org.palladiosimulator.simulizar.slidingwindow.impl.SimulizarSlidingWindow;
import org.palladiosimulator.simulizar.slidingwindow.runtimemeasurement.SlidingWindowRuntimeMeasurementsRecorder;

public final class AggregatorHelper {
    private AggregatorHelper() {
    }

    public static void setupRuntimeAggregatorForMeasurementSpecification(MeasurementSpecification measurementSpecification, Calculator calculator, RuntimeMeasurementModel runtimeMeasurementModel, SimuComModel model) {
        if (Objects.requireNonNull(measurementSpecification).isTriggersSelfAdaptations() && measurementSpecification.getMonitor().isActivated()) {
            TimeDrivenAggregation aggregation = AggregatorHelper.checkAndGetProcessingType(measurementSpecification);
            NumericalBaseMetricDescription expectedMetric = AggregatorHelper.checkAndGetNumericalBaseMetric(measurementSpecification);
            KeepLastElementPriorToLowerBoundStrategy moveOnStrategy = null;
            switch (expectedMetric.getScopeOfValidity()) {
                case CONTINUOUS: {
                    moveOnStrategy = new KeepLastElementPriorToLowerBoundStrategy();
                    break;
                }
                case DISCRETE: {
                    moveOnStrategy = new DiscardAllElementsPriorToLowerBoundStrategy();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            SlidingWindowStatisticalCharacterizationAggregator windowAggregator = new SlidingWindowStatisticalCharacterizationAggregator(aggregation.getStatisticalCharacterization().getAggregator(expectedMetric));
            Objects.requireNonNull(calculator).addObserver((IMeasurementSourceListener)new SlidingWindowRecorder((SlidingWindow)new SimulizarSlidingWindow((Measure<Double, Duration>)aggregation.getWindowLengthAsMeasure(), (Measure<Double, Duration>)aggregation.getWindowIncrementAsMeasure(), (MetricDescription)expectedMetric, (ISlidingWindowMoveOnStrategy)moveOnStrategy, Objects.requireNonNull(model)), (ISlidingWindowListener)windowAggregator));
            windowAggregator.addRecorder(new SlidingWindowRuntimeMeasurementsRecorder(Objects.requireNonNull(runtimeMeasurementModel), measurementSpecification, measurementSpecification.getMonitor().getMeasuringPoint()));
        }
    }

    private static NumericalBaseMetricDescription checkAndGetNumericalBaseMetric(MeasurementSpecification measurementSpecification) {
        if (!MetricSpecPackage.Literals.NUMERICAL_BASE_METRIC_DESCRIPTION.isInstance((Object)measurementSpecification.getMetricDescription())) {
            throw new IllegalArgumentException("Time driven aggregation of measurements (sliding window based) cannot be initialized:\nCurrently, only " + MetricSpecPackage.Literals.NUMERICAL_BASE_METRIC_DESCRIPTION.getName() + "s are supported!\n" + "MeasuringPoint '" + measurementSpecification.getMonitor().getMeasuringPoint() + "'\n" + "Affected Monitor: '" + measurementSpecification.getMonitor().getEntityName() + "'");
        }
        return (NumericalBaseMetricDescription)measurementSpecification.getMetricDescription();
    }

    private static TimeDrivenAggregation checkAndGetProcessingType(MeasurementSpecification measurementSpecification) {
        if (!MonitorRepositoryPackage.Literals.TIME_DRIVEN_AGGREGATION.isInstance((Object)measurementSpecification.getProcessingType())) {
            throw new IllegalArgumentException("Time driven aggregation of measurements (sliding window based) cannot be initialized:\nMeasuringPoint '" + measurementSpecification.getMonitor().getMeasuringPoint() + "'\n" + "MeasurementSpecification: '" + measurementSpecification.getName() + "'\n" + "Affected Monitor: '" + measurementSpecification.getMonitor().getEntityName() + "'\n" + MonitorRepositoryPackage.Literals.PROCESSING_TYPE.getName() + " must be " + MonitorRepositoryPackage.Literals.TIME_DRIVEN_AGGREGATION.getName());
        }
        return (TimeDrivenAggregation)measurementSpecification.getProcessingType();
    }
}

