package org.palladiosimulator.simulizar.launcher.jobs.extensions;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyPassiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.EntryLevelSystemCallMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.ExternalCallActionMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.PcmmeasuringpointFactory;
import org.palladiosimulator.pcmmeasuringpoint.SystemOperationMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.UsageScenarioMeasuringPoint;

@SuppressWarnings("all")
public class DefaultMeasuringPointRepositoryFactory {
  private static final MeasuringpointFactory mf = MeasuringpointFactory.eINSTANCE;

  private static final PcmmeasuringpointFactory pmf = PcmmeasuringpointFactory.eINSTANCE;

  public static MeasuringPointRepository createDefaultRepository(final ResourceSet resourceSet) {
    MeasuringPointRepository _xblockexpression = null;
    {
      final MeasuringPointRepository result = DefaultMeasuringPointRepositoryFactory.mf.createMeasuringPointRepository();
      final Procedure1<Notifier> _function = (Notifier it) -> {
        DefaultMeasuringPointRepositoryFactory.createMeasuringPoint(it, result);
      };
      IteratorExtensions.<Notifier>forEach(resourceSet.getAllContents(), _function);
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  protected static Boolean _createMeasuringPoint(final Notifier notifier, final MeasuringPointRepository repository) {
    return null;
  }

  protected static Boolean _createMeasuringPoint(final UsageScenario scenario, final MeasuringPointRepository repository) {
    EList<MeasuringPoint> _measuringPoints = repository.getMeasuringPoints();
    UsageScenarioMeasuringPoint _createUsageScenarioMeasuringPoint = DefaultMeasuringPointRepositoryFactory.pmf.createUsageScenarioMeasuringPoint();
    final Procedure1<UsageScenarioMeasuringPoint> _function = (UsageScenarioMeasuringPoint it) -> {
      it.setUsageScenario(scenario);
    };
    UsageScenarioMeasuringPoint _doubleArrow = ObjectExtensions.<UsageScenarioMeasuringPoint>operator_doubleArrow(_createUsageScenarioMeasuringPoint, _function);
    return Boolean.valueOf(_measuringPoints.add(_doubleArrow));
  }

  protected static Boolean _createMeasuringPoint(final ProcessingResourceSpecification procSpec, final MeasuringPointRepository repository) {
    EList<MeasuringPoint> _measuringPoints = repository.getMeasuringPoints();
    ActiveResourceMeasuringPoint _createActiveResourceMeasuringPoint = DefaultMeasuringPointRepositoryFactory.pmf.createActiveResourceMeasuringPoint();
    final Procedure1<ActiveResourceMeasuringPoint> _function = (ActiveResourceMeasuringPoint it) -> {
      it.setActiveResource(procSpec);
      it.setReplicaID(0);
    };
    ActiveResourceMeasuringPoint _doubleArrow = ObjectExtensions.<ActiveResourceMeasuringPoint>operator_doubleArrow(_createActiveResourceMeasuringPoint, _function);
    return Boolean.valueOf(_measuringPoints.add(_doubleArrow));
  }

  protected static Boolean _createMeasuringPoint(final ExternalCallAction call, final MeasuringPointRepository repository) {
    EList<MeasuringPoint> _measuringPoints = repository.getMeasuringPoints();
    ExternalCallActionMeasuringPoint _createExternalCallActionMeasuringPoint = DefaultMeasuringPointRepositoryFactory.pmf.createExternalCallActionMeasuringPoint();
    final Procedure1<ExternalCallActionMeasuringPoint> _function = (ExternalCallActionMeasuringPoint it) -> {
      it.setExternalCall(call);
    };
    ExternalCallActionMeasuringPoint _doubleArrow = ObjectExtensions.<ExternalCallActionMeasuringPoint>operator_doubleArrow(_createExternalCallActionMeasuringPoint, _function);
    return Boolean.valueOf(_measuringPoints.add(_doubleArrow));
  }

  protected static Boolean _createMeasuringPoint(final EntryLevelSystemCall call, final MeasuringPointRepository repository) {
    EList<MeasuringPoint> _measuringPoints = repository.getMeasuringPoints();
    EntryLevelSystemCallMeasuringPoint _createEntryLevelSystemCallMeasuringPoint = DefaultMeasuringPointRepositoryFactory.pmf.createEntryLevelSystemCallMeasuringPoint();
    final Procedure1<EntryLevelSystemCallMeasuringPoint> _function = (EntryLevelSystemCallMeasuringPoint it) -> {
      it.setEntryLevelSystemCall(call);
    };
    EntryLevelSystemCallMeasuringPoint _doubleArrow = ObjectExtensions.<EntryLevelSystemCallMeasuringPoint>operator_doubleArrow(_createEntryLevelSystemCallMeasuringPoint, _function);
    return Boolean.valueOf(_measuringPoints.add(_doubleArrow));
  }

  protected static Boolean _createMeasuringPoint(final AssemblyContext context, final MeasuringPointRepository repository) {
    final RepositoryComponent component = context.getEncapsulatedComponent__AssemblyContext();
    if ((component instanceof BasicComponent)) {
      final Consumer<PassiveResource> _function = (PassiveResource res) -> {
        EList<MeasuringPoint> _measuringPoints = repository.getMeasuringPoints();
        AssemblyPassiveResourceMeasuringPoint _createAssemblyPassiveResourceMeasuringPoint = DefaultMeasuringPointRepositoryFactory.pmf.createAssemblyPassiveResourceMeasuringPoint();
        final Procedure1<AssemblyPassiveResourceMeasuringPoint> _function_1 = (AssemblyPassiveResourceMeasuringPoint it) -> {
          it.setAssembly(context);
          it.setPassiveResource(res);
        };
        AssemblyPassiveResourceMeasuringPoint _doubleArrow = ObjectExtensions.<AssemblyPassiveResourceMeasuringPoint>operator_doubleArrow(_createAssemblyPassiveResourceMeasuringPoint, _function_1);
        _measuringPoints.add(_doubleArrow);
      };
      ((BasicComponent)component).getPassiveResource_BasicComponent().forEach(_function);
    }
    return null;
  }

  protected static Boolean _createMeasuringPoint(final org.palladiosimulator.pcm.system.System sys, final MeasuringPointRepository repository) {
    final Consumer<OperationProvidedRole> _function = (OperationProvidedRole provided) -> {
      final Consumer<OperationSignature> _function_1 = (OperationSignature signature) -> {
        EList<MeasuringPoint> _measuringPoints = repository.getMeasuringPoints();
        SystemOperationMeasuringPoint _createSystemOperationMeasuringPoint = DefaultMeasuringPointRepositoryFactory.pmf.createSystemOperationMeasuringPoint();
        final Procedure1<SystemOperationMeasuringPoint> _function_2 = (SystemOperationMeasuringPoint it) -> {
          it.setOperationSignature(signature);
          it.setRole(provided);
          it.setSystem(sys);
        };
        SystemOperationMeasuringPoint _doubleArrow = ObjectExtensions.<SystemOperationMeasuringPoint>operator_doubleArrow(_createSystemOperationMeasuringPoint, _function_2);
        _measuringPoints.add(_doubleArrow);
      };
      Iterables.<OperationSignature>filter(provided.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface(), OperationSignature.class).forEach(_function_1);
    };
    Iterables.<OperationProvidedRole>filter(sys.getProvidedRoles_InterfaceProvidingEntity(), OperationProvidedRole.class).forEach(_function);
    return null;
  }

  public static Boolean createMeasuringPoint(final Notifier sys, final MeasuringPointRepository repository) {
    if (sys instanceof org.palladiosimulator.pcm.system.System) {
      return _createMeasuringPoint((org.palladiosimulator.pcm.system.System)sys, repository);
    } else if (sys instanceof ExternalCallAction) {
      return _createMeasuringPoint((ExternalCallAction)sys, repository);
    } else if (sys instanceof EntryLevelSystemCall) {
      return _createMeasuringPoint((EntryLevelSystemCall)sys, repository);
    } else if (sys instanceof AssemblyContext) {
      return _createMeasuringPoint((AssemblyContext)sys, repository);
    } else if (sys instanceof UsageScenario) {
      return _createMeasuringPoint((UsageScenario)sys, repository);
    } else if (sys instanceof ProcessingResourceSpecification) {
      return _createMeasuringPoint((ProcessingResourceSpecification)sys, repository);
    } else if (sys != null) {
      return _createMeasuringPoint(sys, repository);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(sys, repository).toString());
    }
  }
}
