package org.palladiosimulator.simulizar.launcher.jobs.extensions;

import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryFactory;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyPassiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.ExternalCallActionMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.SystemOperationMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.UsageScenarioMeasuringPoint;

@SuppressWarnings("all")
public class DefaultMonitorRepositoryFactory {
  private static final MonitorRepositoryFactory mf = MonitorRepositoryFactory.eINSTANCE;

  public static MonitorRepository createDefaultMonitorRepository(final MeasuringPointRepository measuringPointRepo) {
    MonitorRepository _xblockexpression = null;
    {
      final MonitorRepository result = DefaultMonitorRepositoryFactory.mf.createMonitorRepository();
      final Consumer<MeasuringPoint> _function = (MeasuringPoint it) -> {
        DefaultMonitorRepositoryFactory.createDefaultMonitors(it, result);
      };
      measuringPointRepo.getMeasuringPoints().forEach(_function);
      _xblockexpression = result;
    }
    return _xblockexpression;
  }

  protected static Boolean _createDefaultMonitors(final MeasuringPoint p, final MonitorRepository repo) {
    return null;
  }

  protected static Boolean _createDefaultMonitors(final UsageScenarioMeasuringPoint p, final MonitorRepository repo) {
    EList<Monitor> _monitors = repo.getMonitors();
    Monitor _createMonitor = DefaultMonitorRepositoryFactory.mf.createMonitor();
    final Procedure1<Monitor> _function = (Monitor it) -> {
      it.setMeasuringPoint(p);
      EList<MeasurementSpecification> _measurementSpecifications = it.getMeasurementSpecifications();
      MeasurementSpecification _createMeasurementSpecification = DefaultMonitorRepositoryFactory.mf.createMeasurementSpecification();
      final Procedure1<MeasurementSpecification> _function_1 = (MeasurementSpecification it_1) -> {
        it_1.setMetricDescription(MetricDescriptionConstants.RESPONSE_TIME_METRIC);
        it_1.setTriggersSelfAdaptations(false);
        it_1.setProcessingType(DefaultMonitorRepositoryFactory.mf.createFeedThrough());
      };
      MeasurementSpecification _doubleArrow = ObjectExtensions.<MeasurementSpecification>operator_doubleArrow(_createMeasurementSpecification, _function_1);
      _measurementSpecifications.add(_doubleArrow);
    };
    Monitor _doubleArrow = ObjectExtensions.<Monitor>operator_doubleArrow(_createMonitor, _function);
    return Boolean.valueOf(_monitors.add(_doubleArrow));
  }

  protected static Boolean _createDefaultMonitors(final SystemOperationMeasuringPoint p, final MonitorRepository repo) {
    EList<Monitor> _monitors = repo.getMonitors();
    Monitor _createMonitor = DefaultMonitorRepositoryFactory.mf.createMonitor();
    final Procedure1<Monitor> _function = (Monitor it) -> {
      it.setMeasuringPoint(p);
      EList<MeasurementSpecification> _measurementSpecifications = it.getMeasurementSpecifications();
      MeasurementSpecification _createMeasurementSpecification = DefaultMonitorRepositoryFactory.mf.createMeasurementSpecification();
      final Procedure1<MeasurementSpecification> _function_1 = (MeasurementSpecification it_1) -> {
        it_1.setMetricDescription(MetricDescriptionConstants.RESPONSE_TIME_METRIC);
        it_1.setTriggersSelfAdaptations(false);
        it_1.setProcessingType(DefaultMonitorRepositoryFactory.mf.createFeedThrough());
      };
      MeasurementSpecification _doubleArrow = ObjectExtensions.<MeasurementSpecification>operator_doubleArrow(_createMeasurementSpecification, _function_1);
      _measurementSpecifications.add(_doubleArrow);
    };
    Monitor _doubleArrow = ObjectExtensions.<Monitor>operator_doubleArrow(_createMonitor, _function);
    return Boolean.valueOf(_monitors.add(_doubleArrow));
  }

  protected static Boolean _createDefaultMonitors(final ExternalCallActionMeasuringPoint p, final MonitorRepository repo) {
    EList<Monitor> _monitors = repo.getMonitors();
    Monitor _createMonitor = DefaultMonitorRepositoryFactory.mf.createMonitor();
    final Procedure1<Monitor> _function = (Monitor it) -> {
      it.setMeasuringPoint(p);
      EList<MeasurementSpecification> _measurementSpecifications = it.getMeasurementSpecifications();
      MeasurementSpecification _createMeasurementSpecification = DefaultMonitorRepositoryFactory.mf.createMeasurementSpecification();
      final Procedure1<MeasurementSpecification> _function_1 = (MeasurementSpecification it_1) -> {
        it_1.setMetricDescription(MetricDescriptionConstants.RESPONSE_TIME_METRIC);
        it_1.setTriggersSelfAdaptations(false);
        it_1.setProcessingType(DefaultMonitorRepositoryFactory.mf.createFeedThrough());
      };
      MeasurementSpecification _doubleArrow = ObjectExtensions.<MeasurementSpecification>operator_doubleArrow(_createMeasurementSpecification, _function_1);
      _measurementSpecifications.add(_doubleArrow);
    };
    Monitor _doubleArrow = ObjectExtensions.<Monitor>operator_doubleArrow(_createMonitor, _function);
    return Boolean.valueOf(_monitors.add(_doubleArrow));
  }

  protected static Boolean _createDefaultMonitors(final ActiveResourceMeasuringPoint p, final MonitorRepository repo) {
    EList<Monitor> _monitors = repo.getMonitors();
    Monitor _createMonitor = DefaultMonitorRepositoryFactory.mf.createMonitor();
    final Procedure1<Monitor> _function = (Monitor it) -> {
      it.setMeasuringPoint(p);
      EList<MeasurementSpecification> _measurementSpecifications = it.getMeasurementSpecifications();
      MeasurementSpecification _createMeasurementSpecification = DefaultMonitorRepositoryFactory.mf.createMeasurementSpecification();
      final Procedure1<MeasurementSpecification> _function_1 = (MeasurementSpecification it_1) -> {
        it_1.setMetricDescription(MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC);
        it_1.setTriggersSelfAdaptations(false);
        it_1.setProcessingType(DefaultMonitorRepositoryFactory.mf.createFeedThrough());
      };
      MeasurementSpecification _doubleArrow = ObjectExtensions.<MeasurementSpecification>operator_doubleArrow(_createMeasurementSpecification, _function_1);
      _measurementSpecifications.add(_doubleArrow);
      EList<MeasurementSpecification> _measurementSpecifications_1 = it.getMeasurementSpecifications();
      MeasurementSpecification _createMeasurementSpecification_1 = DefaultMonitorRepositoryFactory.mf.createMeasurementSpecification();
      final Procedure1<MeasurementSpecification> _function_2 = (MeasurementSpecification it_1) -> {
        it_1.setMetricDescription(MetricDescriptionConstants.RESOURCE_DEMAND_METRIC);
        it_1.setTriggersSelfAdaptations(false);
        it_1.setProcessingType(DefaultMonitorRepositoryFactory.mf.createFeedThrough());
      };
      MeasurementSpecification _doubleArrow_1 = ObjectExtensions.<MeasurementSpecification>operator_doubleArrow(_createMeasurementSpecification_1, _function_2);
      _measurementSpecifications_1.add(_doubleArrow_1);
    };
    Monitor _doubleArrow = ObjectExtensions.<Monitor>operator_doubleArrow(_createMonitor, _function);
    return Boolean.valueOf(_monitors.add(_doubleArrow));
  }

  protected static Boolean _createDefaultMonitors(final AssemblyPassiveResourceMeasuringPoint p, final MonitorRepository repo) {
    EList<Monitor> _monitors = repo.getMonitors();
    Monitor _createMonitor = DefaultMonitorRepositoryFactory.mf.createMonitor();
    final Procedure1<Monitor> _function = (Monitor it) -> {
      it.setMeasuringPoint(p);
      EList<MeasurementSpecification> _measurementSpecifications = it.getMeasurementSpecifications();
      MeasurementSpecification _createMeasurementSpecification = DefaultMonitorRepositoryFactory.mf.createMeasurementSpecification();
      final Procedure1<MeasurementSpecification> _function_1 = (MeasurementSpecification it_1) -> {
        it_1.setMetricDescription(MetricDescriptionConstants.WAITING_TIME_METRIC);
        it_1.setTriggersSelfAdaptations(false);
        it_1.setProcessingType(DefaultMonitorRepositoryFactory.mf.createFeedThrough());
      };
      MeasurementSpecification _doubleArrow = ObjectExtensions.<MeasurementSpecification>operator_doubleArrow(_createMeasurementSpecification, _function_1);
      _measurementSpecifications.add(_doubleArrow);
      EList<MeasurementSpecification> _measurementSpecifications_1 = it.getMeasurementSpecifications();
      MeasurementSpecification _createMeasurementSpecification_1 = DefaultMonitorRepositoryFactory.mf.createMeasurementSpecification();
      final Procedure1<MeasurementSpecification> _function_2 = (MeasurementSpecification it_1) -> {
        it_1.setMetricDescription(MetricDescriptionConstants.HOLDING_TIME_METRIC);
        it_1.setTriggersSelfAdaptations(false);
        it_1.setProcessingType(DefaultMonitorRepositoryFactory.mf.createFeedThrough());
      };
      MeasurementSpecification _doubleArrow_1 = ObjectExtensions.<MeasurementSpecification>operator_doubleArrow(_createMeasurementSpecification_1, _function_2);
      _measurementSpecifications_1.add(_doubleArrow_1);
      EList<MeasurementSpecification> _measurementSpecifications_2 = it.getMeasurementSpecifications();
      MeasurementSpecification _createMeasurementSpecification_2 = DefaultMonitorRepositoryFactory.mf.createMeasurementSpecification();
      final Procedure1<MeasurementSpecification> _function_3 = (MeasurementSpecification it_1) -> {
        it_1.setMetricDescription(MetricDescriptionConstants.STATE_OF_PASSIVE_RESOURCE_METRIC);
        it_1.setTriggersSelfAdaptations(false);
        it_1.setProcessingType(DefaultMonitorRepositoryFactory.mf.createFeedThrough());
      };
      MeasurementSpecification _doubleArrow_2 = ObjectExtensions.<MeasurementSpecification>operator_doubleArrow(_createMeasurementSpecification_2, _function_3);
      _measurementSpecifications_2.add(_doubleArrow_2);
    };
    Monitor _doubleArrow = ObjectExtensions.<Monitor>operator_doubleArrow(_createMonitor, _function);
    return Boolean.valueOf(_monitors.add(_doubleArrow));
  }

  public static Boolean createDefaultMonitors(final MeasuringPoint p, final MonitorRepository repo) {
    if (p instanceof ActiveResourceMeasuringPoint) {
      return _createDefaultMonitors((ActiveResourceMeasuringPoint)p, repo);
    } else if (p instanceof AssemblyPassiveResourceMeasuringPoint) {
      return _createDefaultMonitors((AssemblyPassiveResourceMeasuringPoint)p, repo);
    } else if (p instanceof ExternalCallActionMeasuringPoint) {
      return _createDefaultMonitors((ExternalCallActionMeasuringPoint)p, repo);
    } else if (p instanceof SystemOperationMeasuringPoint) {
      return _createDefaultMonitors((SystemOperationMeasuringPoint)p, repo);
    } else if (p instanceof UsageScenarioMeasuringPoint) {
      return _createDefaultMonitors((UsageScenarioMeasuringPoint)p, repo);
    } else if (p != null) {
      return _createDefaultMonitors(p, repo);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(p, repo).toString());
    }
  }
}
