package org.palladiosimulator.simulizar.test.commons.di.components;

import com.google.common.collect.ImmutableSet;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.SetFactory;
import de.uka.ipd.sdq.simucomframework.core.SimuComConfig;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.Set;
import javax.annotation.processing.Generated;
import javax.inject.Provider;
import org.palladiosimulator.simulizar.core.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.di.base.extension.ExtensionComponent;
import org.palladiosimulator.simulizar.di.component.dependency.QUALComponent;
import org.palladiosimulator.simulizar.di.component.dependency.SimEngineComponent;
import org.palladiosimulator.simulizar.di.component.dependency.SimuComFrameworkComponent;
import org.palladiosimulator.simulizar.di.component.interfaces.AnalysisRuntimeComponent;
import org.palladiosimulator.simulizar.di.extension.ExtensionComponentDependencyResolution;
import org.palladiosimulator.simulizar.di.extension.ExtensionLookup;
import org.palladiosimulator.simulizar.di.extension.GenericExtensionComponent;
import org.palladiosimulator.simulizar.di.modules.component.core.SimuLizarRootModule_BindRegisteredComponentsFactory;
import org.palladiosimulator.simulizar.di.modules.component.extensions.ExtensionComponentsModule;
import org.palladiosimulator.simulizar.di.modules.component.extensions.ExtensionComponentsModule_ProvideBootstrapExtensionsFactory;
import org.palladiosimulator.simulizar.di.modules.component.extensions.ExtensionComponentsModule_ProvideExtensionFactoriesFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.root.DependencyComponentsModule_ProvideQualComponentFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.root.DependencyComponentsModule_ProvideSimEngineComponentFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.root.DependencyComponentsModule_ProvideSimuComFrameworkComponentFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.root.ExtensionComponentRootExtensionBindings_ModelContributionsFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.root.ExtensionComponentRootExtensionBindings_ProvideDependencyResolutionFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.root.ExtensionComponentRootExtensionBindings_ProvideExtensionCompletionJobsFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.root.ExtensionComponentRootExtensionBindings_ProvideExtensionLookupFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.root.ExtensionComponentRootExtensionBindings_ProvideExtensionPartitionContributionFactory;
import org.palladiosimulator.simulizar.di.modules.scoped.root.ExtensionComponentRootExtensionBindings_ProvideRootExtensionsFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.configuration.SimuLizarConfigurationModule_ProvideSimuComConfigFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.core.DefaultSimuLizarRuntimeFactoryModule_ProvideAnalysisRuntimeComponentFactoryFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.core.RootComponentFactoriesModule;
import org.palladiosimulator.simulizar.di.modules.stateless.core.RootComponentFactoriesModule_ProvidesQUALComponentFactoryFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.core.RootComponentFactoriesModule_ProvidesRuntimeComponentFactoryFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.core.RootComponentFactoriesModule_ProvidesSimEngineComponentFactoryFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.core.RootComponentFactoriesModule_ProvidesSimuComFrameworkComponentFactoryFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.extension.ExtensionSupportModule_ProvidesExtensionComponentsFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.extension.ExtensionSupportModule_ProvidesGenericExtensionComponentsFactory;
import org.palladiosimulator.simulizar.di.modules.stateless.mdsd.MDSDBlackboardProvidingModule;
import org.palladiosimulator.simulizar.di.modules.stateless.mdsd.MDSDBlackboardProvidingModule_ProvideBlackboardFactory;
import org.palladiosimulator.simulizar.launcher.jobs.ModelCompletionJobContributor;
import org.palladiosimulator.simulizar.launcher.jobs.ModelCompletionsJob;
import org.palladiosimulator.simulizar.launcher.jobs.ModelCompletionsJob_Factory;
import org.palladiosimulator.simulizar.launcher.jobs.ModelContribution;
import org.palladiosimulator.simulizar.launcher.jobs.PartitionContribution;
import org.palladiosimulator.simulizar.launcher.jobs.SimuLizarRootJob;
import org.palladiosimulator.simulizar.launcher.jobs.extensions.DefaultMonitorRepositoryCompletionContributor;
import org.palladiosimulator.simulizar.launcher.jobs.extensions.DefaultMonitorRepositoryCompletionContributor_Factory;
import org.palladiosimulator.simulizar.test.commons.di.overrides.TestSimuLizarLoadModelsJob;
import org.palladiosimulator.simulizar.test.commons.di.overrides.TestSimuLizarLoadModelsJob_Factory;
import org.palladiosimulator.simulizar.test.commons.di.overrides.TestSimuLizarPrepareBlackboardJob;
import org.palladiosimulator.simulizar.test.commons.di.overrides.TestSimuLizarPrepareBlackboardJob_Factory;

@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes"
})
public final class DaggerTestSimuLizarRootComponent implements TestSimuLizarRootComponent {
  private final SimuLizarWorkflowConfiguration configuration;

  private final MDSDBlackboardProvidingModule mDSDBlackboardProvidingModule;

  private final RootComponentFactoriesModule rootComponentFactoriesModule;

  private final ExtensionComponentsModule extensionComponentsModule;

  private Provider<TestSimuLizarRootComponent> testSimuLizarRootComponentProvider;

  private Provider<Set<Object>> bindRegisteredComponentsProvider;

  private Provider<Set<Object>> provideBootstrapExtensionsProvider;

  private Provider<Set<Object>> registeredComponentSetOfObjectProvider;

  private Provider<Set<ExtensionComponent.Factory>> provideExtensionFactoriesProvider;

  private Provider<Set<ExtensionComponent.Factory>> setOfExtensionComponentFactoryProvider;

  private Provider<ExtensionComponentDependencyResolution> provideDependencyResolutionProvider;

  private Provider<Set<ExtensionComponent>> providesExtensionComponentsProvider;

  private Provider<Set<ExtensionComponent>> setOfExtensionComponentProvider;

  private Provider<Set<GenericExtensionComponent>> providesGenericExtensionComponentsProvider;

  private Provider<Set<GenericExtensionComponent>> setOfGenericExtensionComponentProvider;

  private Provider<ExtensionLookup> provideExtensionLookupProvider;

  private Provider<Set<PartitionContribution>> provideExtensionPartitionContributionProvider;

  private Provider<Set<PartitionContribution>> setOfPartitionContributionProvider;

  private Provider<Boolean> activateModelLoadingProvider;

  private Provider<TestSimuLizarPrepareBlackboardJob> testSimuLizarPrepareBlackboardJobProvider;

  private Provider<SimuLizarWorkflowConfiguration> configurationProvider;

  private Provider<Set<ModelContribution>> modelContributionsProvider;

  private Provider<Set<ModelContribution>> setOfModelContributionProvider;

  private Provider<TestSimuLizarLoadModelsJob> testSimuLizarLoadModelsJobProvider;

  private Provider<Set<ModelCompletionJobContributor>> provideExtensionCompletionJobsProvider;

  private Provider<MDSDBlackboard> provideBlackboardProvider;

  private Provider<DefaultMonitorRepositoryCompletionContributor> defaultMonitorRepositoryCompletionContributorProvider;

  private Provider<ModelCompletionJobContributor> bindDefaultMonitorRepositoryCompletionProvider;

  private Provider<Set<ModelCompletionJobContributor>> setOfModelCompletionJobContributorProvider;

  private Provider<ModelCompletionsJob> modelCompletionsJobProvider;

  private Provider<QUALComponent.Factory> providesQUALComponentFactoryProvider;

  private Provider<QUALComponent> provideQualComponentProvider;

  private Provider<SimuComFrameworkComponent.Factory> providesSimuComFrameworkComponentFactoryProvider;

  private Provider<SimuComConfig> provideSimuComConfigProvider;

  private Provider<SimEngineComponent.Factory> providesSimEngineComponentFactoryProvider;

  private Provider<SimEngineComponent> provideSimEngineComponentProvider;

  private Provider<SimuComFrameworkComponent> provideSimuComFrameworkComponentProvider;

  private Provider<Set<ExtensionComponent>> provideRootExtensionsProvider;

  private DaggerTestSimuLizarRootComponent(
      MDSDBlackboardProvidingModule mDSDBlackboardProvidingModuleParam,
      RootComponentFactoriesModule rootComponentFactoriesModuleParam,
      ExtensionComponentsModule extensionComponentsModuleParam,
      TestSimuLizarRootComponent.TestConfigurationModule testConfigurationModuleParam,
      SimuLizarWorkflowConfiguration configurationParam) {
    this.configuration = configurationParam;
    this.mDSDBlackboardProvidingModule = mDSDBlackboardProvidingModuleParam;
    this.rootComponentFactoriesModule = rootComponentFactoriesModuleParam;
    this.extensionComponentsModule = extensionComponentsModuleParam;
    initialize(mDSDBlackboardProvidingModuleParam, rootComponentFactoriesModuleParam, extensionComponentsModuleParam, testConfigurationModuleParam, configurationParam);
  }

  public static TestSimuLizarRootComponent.Factory factory() {
    return new Factory();
  }

  private SimuLizarRootJob simuLizarRootJob() {
    return new SimuLizarRootJob(configuration, MDSDBlackboardProvidingModule_ProvideBlackboardFactory.provideBlackboard(mDSDBlackboardProvidingModule), (Provider) testSimuLizarPrepareBlackboardJobProvider, (Provider) testSimuLizarLoadModelsJobProvider, modelCompletionsJobProvider, runtimeComponentFactory());
  }

  private Set<Object> registeredComponentSetOfObject() {
    return ImmutableSet.<Object>builderWithExpectedSize(2).addAll(bindRegisteredComponentsProvider.get()).addAll(ExtensionComponentsModule_ProvideBootstrapExtensionsFactory.provideBootstrapExtensions(extensionComponentsModule)).build();
  }

  private Set<ExtensionComponent.Factory> setOfExtensionComponentFactory() {
    return ImmutableSet.<ExtensionComponent.Factory>copyOf(ExtensionComponentsModule_ProvideExtensionFactoriesFactory.provideExtensionFactories(extensionComponentsModule));
  }

  @SuppressWarnings("unchecked")
  private void initialize(final MDSDBlackboardProvidingModule mDSDBlackboardProvidingModuleParam,
      final RootComponentFactoriesModule rootComponentFactoriesModuleParam,
      final ExtensionComponentsModule extensionComponentsModuleParam,
      final TestSimuLizarRootComponent.TestConfigurationModule testConfigurationModuleParam,
      final SimuLizarWorkflowConfiguration configurationParam) {
    this.testSimuLizarRootComponentProvider = InstanceFactory.create((TestSimuLizarRootComponent) this);
    this.bindRegisteredComponentsProvider = DoubleCheck.provider(SimuLizarRootModule_BindRegisteredComponentsFactory.create((Provider) testSimuLizarRootComponentProvider));
    this.provideBootstrapExtensionsProvider = ExtensionComponentsModule_ProvideBootstrapExtensionsFactory.create(extensionComponentsModuleParam);
    this.registeredComponentSetOfObjectProvider = SetFactory.<Object>builder(0, 2).addCollectionProvider(bindRegisteredComponentsProvider).addCollectionProvider(provideBootstrapExtensionsProvider).build();
    this.provideExtensionFactoriesProvider = ExtensionComponentsModule_ProvideExtensionFactoriesFactory.create(extensionComponentsModuleParam);
    this.setOfExtensionComponentFactoryProvider = SetFactory.<ExtensionComponent.Factory>builder(0, 1).addCollectionProvider(provideExtensionFactoriesProvider).build();
    this.provideDependencyResolutionProvider = DoubleCheck.provider(ExtensionComponentRootExtensionBindings_ProvideDependencyResolutionFactory.create(registeredComponentSetOfObjectProvider, setOfExtensionComponentFactoryProvider));
    this.providesExtensionComponentsProvider = ExtensionSupportModule_ProvidesExtensionComponentsFactory.create(provideDependencyResolutionProvider);
    this.setOfExtensionComponentProvider = SetFactory.<ExtensionComponent>builder(0, 1).addCollectionProvider(providesExtensionComponentsProvider).build();
    this.providesGenericExtensionComponentsProvider = ExtensionSupportModule_ProvidesGenericExtensionComponentsFactory.create(setOfExtensionComponentProvider);
    this.setOfGenericExtensionComponentProvider = SetFactory.<GenericExtensionComponent>builder(0, 1).addCollectionProvider(providesGenericExtensionComponentsProvider).build();
    this.provideExtensionLookupProvider = DoubleCheck.provider(ExtensionComponentRootExtensionBindings_ProvideExtensionLookupFactory.create(setOfGenericExtensionComponentProvider));
    this.provideExtensionPartitionContributionProvider = DoubleCheck.provider(ExtensionComponentRootExtensionBindings_ProvideExtensionPartitionContributionFactory.create(provideExtensionLookupProvider));
    this.setOfPartitionContributionProvider = SetFactory.<PartitionContribution>builder(0, 1).addCollectionProvider(provideExtensionPartitionContributionProvider).build();
    this.activateModelLoadingProvider = TestSimuLizarRootComponent_TestConfigurationModule_ActivateModelLoadingFactory.create(testConfigurationModuleParam);
    this.testSimuLizarPrepareBlackboardJobProvider = TestSimuLizarPrepareBlackboardJob_Factory.create(setOfPartitionContributionProvider, activateModelLoadingProvider);
    this.configurationProvider = InstanceFactory.create(configurationParam);
    this.modelContributionsProvider = DoubleCheck.provider(ExtensionComponentRootExtensionBindings_ModelContributionsFactory.create(provideExtensionLookupProvider));
    this.setOfModelContributionProvider = SetFactory.<ModelContribution>builder(0, 1).addCollectionProvider(modelContributionsProvider).build();
    this.testSimuLizarLoadModelsJobProvider = TestSimuLizarLoadModelsJob_Factory.create(configurationProvider, setOfModelContributionProvider, activateModelLoadingProvider);
    this.provideExtensionCompletionJobsProvider = DoubleCheck.provider(ExtensionComponentRootExtensionBindings_ProvideExtensionCompletionJobsFactory.create(provideExtensionLookupProvider));
    this.provideBlackboardProvider = MDSDBlackboardProvidingModule_ProvideBlackboardFactory.create(mDSDBlackboardProvidingModuleParam);
    this.defaultMonitorRepositoryCompletionContributorProvider = DefaultMonitorRepositoryCompletionContributor_Factory.create(provideBlackboardProvider);
    this.bindDefaultMonitorRepositoryCompletionProvider = DoubleCheck.provider((Provider) defaultMonitorRepositoryCompletionContributorProvider);
    this.setOfModelCompletionJobContributorProvider = SetFactory.<ModelCompletionJobContributor>builder(1, 1).addCollectionProvider(provideExtensionCompletionJobsProvider).addProvider(bindDefaultMonitorRepositoryCompletionProvider).build();
    this.modelCompletionsJobProvider = ModelCompletionsJob_Factory.create(setOfModelCompletionJobContributorProvider);
    this.providesQUALComponentFactoryProvider = RootComponentFactoriesModule_ProvidesQUALComponentFactoryFactory.create(rootComponentFactoriesModuleParam);
    this.provideQualComponentProvider = DoubleCheck.provider(DependencyComponentsModule_ProvideQualComponentFactory.create(configurationProvider, providesQUALComponentFactoryProvider));
    this.providesSimuComFrameworkComponentFactoryProvider = RootComponentFactoriesModule_ProvidesSimuComFrameworkComponentFactoryFactory.create(rootComponentFactoriesModuleParam);
    this.provideSimuComConfigProvider = SimuLizarConfigurationModule_ProvideSimuComConfigFactory.create(configurationProvider);
    this.providesSimEngineComponentFactoryProvider = RootComponentFactoriesModule_ProvidesSimEngineComponentFactoryFactory.create(rootComponentFactoriesModuleParam);
    this.provideSimEngineComponentProvider = DoubleCheck.provider(DependencyComponentsModule_ProvideSimEngineComponentFactory.create(providesSimEngineComponentFactoryProvider));
    this.provideSimuComFrameworkComponentProvider = DoubleCheck.provider(DependencyComponentsModule_ProvideSimuComFrameworkComponentFactory.create(providesSimuComFrameworkComponentFactoryProvider, provideSimuComConfigProvider, provideQualComponentProvider, provideSimEngineComponentProvider));
    this.provideRootExtensionsProvider = DoubleCheck.provider(ExtensionComponentRootExtensionBindings_ProvideRootExtensionsFactory.create(setOfExtensionComponentProvider));
  }

  @Override
  public IJob rootJob() {
    return simuLizarRootJob();
  }

  @Override
  public MDSDBlackboard blackboard() {
    return MDSDBlackboardProvidingModule_ProvideBlackboardFactory.provideBlackboard(mDSDBlackboardProvidingModule);
  }

  @Override
  public SimuLizarWorkflowConfiguration config() {
    return configuration;
  }

  @Override
  public AnalysisRuntimeComponent.Factory runtimeComponentFactory() {
    return DefaultSimuLizarRuntimeFactoryModule_ProvideAnalysisRuntimeComponentFactoryFactory.provideAnalysisRuntimeComponentFactory(this, RootComponentFactoriesModule_ProvidesRuntimeComponentFactoryFactory.providesRuntimeComponentFactory(rootComponentFactoriesModule), provideQualComponentProvider, provideSimuComFrameworkComponentProvider, provideSimEngineComponentProvider, registeredComponentSetOfObject(), provideRootExtensionsProvider.get(), setOfExtensionComponentFactory());
  }

  private static final class Factory implements TestSimuLizarRootComponent.Factory {
    @Override
    public TestSimuLizarRootComponent create(SimuLizarWorkflowConfiguration configuration,
        RootComponentFactoriesModule factoriesModule, ExtensionComponentsModule extensionModule,
        MDSDBlackboardProvidingModule blackBoardModule,
        TestSimuLizarRootComponent.TestConfigurationModule configModule) {
      Preconditions.checkNotNull(configuration);
      Preconditions.checkNotNull(factoriesModule);
      Preconditions.checkNotNull(extensionModule);
      Preconditions.checkNotNull(blackBoardModule);
      Preconditions.checkNotNull(configModule);
      return new DaggerTestSimuLizarRootComponent(blackBoardModule, factoriesModule, extensionModule, configModule, configuration);
    }
  }
}
