package org.palladiosimulator.simulizar.test.commons.models;

import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.CompositeComponent;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.subsystem.SubSystem;

@SuppressWarnings("all")
public class AllocationLookupSyncerTestModels extends TestModelBase {
  public static class TrivialAllocation extends TestModelBase.Empty {
    public static final String RCId = "ResourceContainer1";

    public static final String AssemblyCtxId = "0123456789";

    @Override
    public PCMResourceSetPartition get() {
      PCMResourceSetPartition _get = super.get();
      final Procedure1<PCMResourceSetPartition> _function = (PCMResourceSetPartition it) -> {
        final BasicComponent component = TestModelBase.rf.createBasicComponent();
        Repository _head = IterableExtensions.<Repository>head(it.getRepositories());
        final Procedure1<Repository> _function_1 = (Repository it_1) -> {
          EList<RepositoryComponent> _components__Repository = it_1.getComponents__Repository();
          _components__Repository.add(component);
        };
        ObjectExtensions.<Repository>operator_doubleArrow(_head, _function_1);
        AssemblyContext _createAssemblyContext = TestModelBase.cpf.createAssemblyContext();
        final Procedure1<AssemblyContext> _function_2 = (AssemblyContext it_1) -> {
          it_1.setId(AllocationLookupSyncerTestModels.TrivialAllocation.AssemblyCtxId);
          it_1.setEncapsulatedComponent__AssemblyContext(component);
        };
        final AssemblyContext assembly = ObjectExtensions.<AssemblyContext>operator_doubleArrow(_createAssemblyContext, _function_2);
        EList<AssemblyContext> _assemblyContexts__ComposedStructure = it.getSystem().getAssemblyContexts__ComposedStructure();
        _assemblyContexts__ComposedStructure.add(assembly);
        ResourceContainer _createResourceContainer = TestModelBase.ref.createResourceContainer();
        final Procedure1<ResourceContainer> _function_3 = (ResourceContainer it_1) -> {
          it_1.setId(AllocationLookupSyncerTestModels.TrivialAllocation.RCId);
        };
        final ResourceContainer rc = ObjectExtensions.<ResourceContainer>operator_doubleArrow(_createResourceContainer, _function_3);
        EList<ResourceContainer> _resourceContainer_ResourceEnvironment = it.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
        _resourceContainer_ResourceEnvironment.add(rc);
        EList<AllocationContext> _allocationContexts_Allocation = it.getAllocation().getAllocationContexts_Allocation();
        AllocationContext _createAllocationContext = TestModelBase.af.createAllocationContext();
        final Procedure1<AllocationContext> _function_4 = (AllocationContext it_1) -> {
          it_1.setAssemblyContext_AllocationContext(assembly);
          it_1.setResourceContainer_AllocationContext(rc);
        };
        AllocationContext _doubleArrow = ObjectExtensions.<AllocationContext>operator_doubleArrow(_createAllocationContext, _function_4);
        _allocationContexts_Allocation.add(_doubleArrow);
      };
      return ObjectExtensions.<PCMResourceSetPartition>operator_doubleArrow(_get, _function);
    }
  }

  public static class CompositeComponentAllocation extends TestModelBase.Empty {
    public static final String RCId = "ResourceContainer1";

    public static final String NestedAssemblyCtxId = "Nested";

    public static final String AssemblyCtx1Id = "Nesting1";

    public static final String AssemblyCtx2Id = "Nesting2";

    @Override
    public PCMResourceSetPartition get() {
      PCMResourceSetPartition _get = super.get();
      final Procedure1<PCMResourceSetPartition> _function = (PCMResourceSetPartition it) -> {
        final BasicComponent nestedComponent = TestModelBase.rf.createBasicComponent();
        CompositeComponent _createCompositeComponent = TestModelBase.rf.createCompositeComponent();
        final Procedure1<CompositeComponent> _function_1 = (CompositeComponent it_1) -> {
          EList<AssemblyContext> _assemblyContexts__ComposedStructure = it_1.getAssemblyContexts__ComposedStructure();
          AssemblyContext _createAssemblyContext = TestModelBase.cpf.createAssemblyContext();
          final Procedure1<AssemblyContext> _function_2 = (AssemblyContext it_2) -> {
            it_2.setId(AllocationLookupSyncerTestModels.CompositeComponentAllocation.NestedAssemblyCtxId);
            it_2.setEncapsulatedComponent__AssemblyContext(nestedComponent);
          };
          AssemblyContext _doubleArrow = ObjectExtensions.<AssemblyContext>operator_doubleArrow(_createAssemblyContext, _function_2);
          _assemblyContexts__ComposedStructure.add(_doubleArrow);
        };
        final CompositeComponent component = ObjectExtensions.<CompositeComponent>operator_doubleArrow(_createCompositeComponent, _function_1);
        Repository _head = IterableExtensions.<Repository>head(it.getRepositories());
        final Procedure1<Repository> _function_2 = (Repository it_1) -> {
          EList<RepositoryComponent> _components__Repository = it_1.getComponents__Repository();
          _components__Repository.add(nestedComponent);
          EList<RepositoryComponent> _components__Repository_1 = it_1.getComponents__Repository();
          _components__Repository_1.add(component);
        };
        ObjectExtensions.<Repository>operator_doubleArrow(_head, _function_2);
        AssemblyContext _createAssemblyContext = TestModelBase.cpf.createAssemblyContext();
        final Procedure1<AssemblyContext> _function_3 = (AssemblyContext it_1) -> {
          it_1.setId(AllocationLookupSyncerTestModels.CompositeComponentAllocation.AssemblyCtx1Id);
          it_1.setEncapsulatedComponent__AssemblyContext(component);
        };
        final AssemblyContext assembly1 = ObjectExtensions.<AssemblyContext>operator_doubleArrow(_createAssemblyContext, _function_3);
        AssemblyContext _createAssemblyContext_1 = TestModelBase.cpf.createAssemblyContext();
        final Procedure1<AssemblyContext> _function_4 = (AssemblyContext it_1) -> {
          it_1.setId(AllocationLookupSyncerTestModels.CompositeComponentAllocation.AssemblyCtx2Id);
          it_1.setEncapsulatedComponent__AssemblyContext(component);
        };
        final AssemblyContext assembly2 = ObjectExtensions.<AssemblyContext>operator_doubleArrow(_createAssemblyContext_1, _function_4);
        EList<AssemblyContext> _assemblyContexts__ComposedStructure = it.getSystem().getAssemblyContexts__ComposedStructure();
        _assemblyContexts__ComposedStructure.add(assembly1);
        EList<AssemblyContext> _assemblyContexts__ComposedStructure_1 = it.getSystem().getAssemblyContexts__ComposedStructure();
        _assemblyContexts__ComposedStructure_1.add(assembly2);
        ResourceContainer _createResourceContainer = TestModelBase.ref.createResourceContainer();
        final Procedure1<ResourceContainer> _function_5 = (ResourceContainer it_1) -> {
          it_1.setId(AllocationLookupSyncerTestModels.CompositeComponentAllocation.RCId);
        };
        final ResourceContainer rc = ObjectExtensions.<ResourceContainer>operator_doubleArrow(_createResourceContainer, _function_5);
        EList<ResourceContainer> _resourceContainer_ResourceEnvironment = it.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
        _resourceContainer_ResourceEnvironment.add(rc);
        EList<AllocationContext> _allocationContexts_Allocation = it.getAllocation().getAllocationContexts_Allocation();
        AllocationContext _createAllocationContext = TestModelBase.af.createAllocationContext();
        final Procedure1<AllocationContext> _function_6 = (AllocationContext it_1) -> {
          it_1.setAssemblyContext_AllocationContext(assembly1);
          it_1.setResourceContainer_AllocationContext(rc);
        };
        AllocationContext _doubleArrow = ObjectExtensions.<AllocationContext>operator_doubleArrow(_createAllocationContext, _function_6);
        _allocationContexts_Allocation.add(_doubleArrow);
        EList<AllocationContext> _allocationContexts_Allocation_1 = it.getAllocation().getAllocationContexts_Allocation();
        AllocationContext _createAllocationContext_1 = TestModelBase.af.createAllocationContext();
        final Procedure1<AllocationContext> _function_7 = (AllocationContext it_1) -> {
          it_1.setAssemblyContext_AllocationContext(assembly2);
          it_1.setResourceContainer_AllocationContext(rc);
        };
        AllocationContext _doubleArrow_1 = ObjectExtensions.<AllocationContext>operator_doubleArrow(_createAllocationContext_1, _function_7);
        _allocationContexts_Allocation_1.add(_doubleArrow_1);
      };
      return ObjectExtensions.<PCMResourceSetPartition>operator_doubleArrow(_get, _function);
    }
  }

  public static class SubsystemWhiteboxAllocation extends TestModelBase.Empty {
    public static final String RCId = "ResourceContainer1";

    public static final String NestedAssemblyCtxId = "Nested";

    public static final String AssemblyCtx1Id = "Nesting1";

    @Override
    public PCMResourceSetPartition get() {
      PCMResourceSetPartition _get = super.get();
      final Procedure1<PCMResourceSetPartition> _function = (PCMResourceSetPartition it) -> {
        final BasicComponent nestedComponent = TestModelBase.rf.createBasicComponent();
        AssemblyContext _createAssemblyContext = TestModelBase.cpf.createAssemblyContext();
        final Procedure1<AssemblyContext> _function_1 = (AssemblyContext it_1) -> {
          it_1.setId(AllocationLookupSyncerTestModels.SubsystemWhiteboxAllocation.NestedAssemblyCtxId);
          it_1.setEncapsulatedComponent__AssemblyContext(nestedComponent);
        };
        final AssemblyContext nestedACtx = ObjectExtensions.<AssemblyContext>operator_doubleArrow(_createAssemblyContext, _function_1);
        SubSystem _createSubSystem = TestModelBase.ssf.createSubSystem();
        final Procedure1<SubSystem> _function_2 = (SubSystem it_1) -> {
          EList<AssemblyContext> _assemblyContexts__ComposedStructure = it_1.getAssemblyContexts__ComposedStructure();
          _assemblyContexts__ComposedStructure.add(nestedACtx);
        };
        final SubSystem component = ObjectExtensions.<SubSystem>operator_doubleArrow(_createSubSystem, _function_2);
        Repository _head = IterableExtensions.<Repository>head(it.getRepositories());
        final Procedure1<Repository> _function_3 = (Repository it_1) -> {
          EList<RepositoryComponent> _components__Repository = it_1.getComponents__Repository();
          _components__Repository.add(nestedComponent);
          EList<RepositoryComponent> _components__Repository_1 = it_1.getComponents__Repository();
          _components__Repository_1.add(component);
        };
        ObjectExtensions.<Repository>operator_doubleArrow(_head, _function_3);
        AssemblyContext _createAssemblyContext_1 = TestModelBase.cpf.createAssemblyContext();
        final Procedure1<AssemblyContext> _function_4 = (AssemblyContext it_1) -> {
          it_1.setId(AllocationLookupSyncerTestModels.SubsystemWhiteboxAllocation.AssemblyCtx1Id);
          it_1.setEncapsulatedComponent__AssemblyContext(component);
        };
        final AssemblyContext assembly1 = ObjectExtensions.<AssemblyContext>operator_doubleArrow(_createAssemblyContext_1, _function_4);
        EList<AssemblyContext> _assemblyContexts__ComposedStructure = it.getSystem().getAssemblyContexts__ComposedStructure();
        _assemblyContexts__ComposedStructure.add(assembly1);
        ResourceContainer _createResourceContainer = TestModelBase.ref.createResourceContainer();
        final Procedure1<ResourceContainer> _function_5 = (ResourceContainer it_1) -> {
          it_1.setId(AllocationLookupSyncerTestModels.SubsystemWhiteboxAllocation.RCId);
        };
        final ResourceContainer rc = ObjectExtensions.<ResourceContainer>operator_doubleArrow(_createResourceContainer, _function_5);
        EList<ResourceContainer> _resourceContainer_ResourceEnvironment = it.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
        _resourceContainer_ResourceEnvironment.add(rc);
        EList<AllocationContext> _allocationContexts_Allocation = it.getAllocation().getAllocationContexts_Allocation();
        AllocationContext _createAllocationContext = TestModelBase.af.createAllocationContext();
        final Procedure1<AllocationContext> _function_6 = (AllocationContext it_1) -> {
          it_1.setAssemblyContext_AllocationContext(nestedACtx);
          it_1.setResourceContainer_AllocationContext(rc);
        };
        AllocationContext _doubleArrow = ObjectExtensions.<AllocationContext>operator_doubleArrow(_createAllocationContext, _function_6);
        _allocationContexts_Allocation.add(_doubleArrow);
      };
      return ObjectExtensions.<PCMResourceSetPartition>operator_doubleArrow(_get, _function);
    }
  }
}
