package org.palladiosimulator.simulizar.test.commons.models;

import java.util.function.Supplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationFactory;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.core.composition.CompositionFactory;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryFactory;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.resourcetype.ResourcetypeFactory;
import org.palladiosimulator.pcm.subsystem.SubsystemFactory;
import org.palladiosimulator.pcm.system.SystemFactory;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsagemodelFactory;

@SuppressWarnings("all")
public class TestModelBase {
  /**
   * Creates a fully instantiated PCMResourceSetPartion with empty models.
   */
  public static class Empty implements Supplier<PCMResourceSetPartition> {
    @Override
    public PCMResourceSetPartition get() {
      PCMResourceSetPartition _xblockexpression = null;
      {
        EcorePlugin.ExtensionProcessor.process(null);
        PCMResourceSetPartition _pCMResourceSetPartition = new PCMResourceSetPartition();
        final Procedure1<PCMResourceSetPartition> _function = (PCMResourceSetPartition rsp) -> {
          ResourceSet _resourceSet = rsp.getResourceSet();
          final Procedure1<ResourceSet> _function_1 = (ResourceSet it) -> {
            Resource _createResource = it.createResource(URI.createFileURI("test.repository"));
            final Procedure1<Resource> _function_2 = (Resource it_1) -> {
              EList<EObject> _contents = it_1.getContents();
              Repository _createRepository = TestModelBase.rf.createRepository();
              _contents.add(_createRepository);
            };
            ObjectExtensions.<Resource>operator_doubleArrow(_createResource, _function_2);
            Resource _createResource_1 = it.createResource(URI.createFileURI("test.system"));
            final Procedure1<Resource> _function_3 = (Resource it_1) -> {
              EList<EObject> _contents = it_1.getContents();
              org.palladiosimulator.pcm.system.System _createSystem = TestModelBase.sf.createSystem();
              _contents.add(_createSystem);
            };
            ObjectExtensions.<Resource>operator_doubleArrow(_createResource_1, _function_3);
            Resource _createResource_2 = it.createResource(URI.createFileURI("test.resourceenvironment"));
            final Procedure1<Resource> _function_4 = (Resource it_1) -> {
              EList<EObject> _contents = it_1.getContents();
              ResourceEnvironment _createResourceEnvironment = TestModelBase.ref.createResourceEnvironment();
              _contents.add(_createResourceEnvironment);
            };
            ObjectExtensions.<Resource>operator_doubleArrow(_createResource_2, _function_4);
            Resource _createResource_3 = it.createResource(URI.createFileURI("test.allocation"));
            final Procedure1<Resource> _function_5 = (Resource it_1) -> {
              EList<EObject> _contents = it_1.getContents();
              Allocation _createAllocation = TestModelBase.af.createAllocation();
              final Procedure1<Allocation> _function_6 = (Allocation it_2) -> {
                it_2.setTargetResourceEnvironment_Allocation(rsp.getResourceEnvironment());
                it_2.setSystem_Allocation(rsp.getSystem());
              };
              Allocation _doubleArrow = ObjectExtensions.<Allocation>operator_doubleArrow(_createAllocation, _function_6);
              _contents.add(_doubleArrow);
            };
            ObjectExtensions.<Resource>operator_doubleArrow(_createResource_3, _function_5);
            Resource _createResource_4 = it.createResource(URI.createFileURI("test.resourcetype"));
            final Procedure1<Resource> _function_6 = (Resource it_1) -> {
              EList<EObject> _contents = it_1.getContents();
              ResourceRepository _createResourceRepository = TestModelBase.rtf.createResourceRepository();
              _contents.add(_createResourceRepository);
            };
            ObjectExtensions.<Resource>operator_doubleArrow(_createResource_4, _function_6);
            Resource _createResource_5 = it.createResource(URI.createFileURI("test.usagemodel"));
            final Procedure1<Resource> _function_7 = (Resource it_1) -> {
              EList<EObject> _contents = it_1.getContents();
              UsageModel _createUsageModel = TestModelBase.uf.createUsageModel();
              _contents.add(_createUsageModel);
            };
            ObjectExtensions.<Resource>operator_doubleArrow(_createResource_5, _function_7);
          };
          ObjectExtensions.<ResourceSet>operator_doubleArrow(_resourceSet, _function_1);
        };
        _xblockexpression = ObjectExtensions.<PCMResourceSetPartition>operator_doubleArrow(_pCMResourceSetPartition, _function);
      }
      return _xblockexpression;
    }
  }

  protected static final AllocationFactory af = AllocationFactory.eINSTANCE;

  protected static final CompositionFactory cpf = CompositionFactory.eINSTANCE;

  protected static final CoreFactory cf = CoreFactory.eINSTANCE;

  protected static final RepositoryFactory rf = RepositoryFactory.eINSTANCE;

  protected static final SystemFactory sf = SystemFactory.eINSTANCE;

  protected static final SubsystemFactory ssf = SubsystemFactory.eINSTANCE;

  protected static final ResourceenvironmentFactory ref = ResourceenvironmentFactory.eINSTANCE;

  protected static final ResourcetypeFactory rtf = ResourcetypeFactory.eINSTANCE;

  protected static final UsagemodelFactory uf = UsagemodelFactory.eINSTANCE;

  /**
   * Creates a StoEx based on the provided specification string.
   */
  public static PCMRandomVariable stoex(final String spec) {
    PCMRandomVariable _createPCMRandomVariable = TestModelBase.cf.createPCMRandomVariable();
    final Procedure1<PCMRandomVariable> _function = (PCMRandomVariable it) -> {
      it.setSpecification(spec);
    };
    return ObjectExtensions.<PCMRandomVariable>operator_doubleArrow(_createPCMRandomVariable, _function);
  }
}
