/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.test.commons.extension;

import com.google.common.collect.Streams;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.simulizar.test.commons.annotation.PredicateFactory;

public final class SimuLizarTestExtensionCommons {
    public static final ExtensionContext.Namespace SIMULIZAR = ExtensionContext.Namespace.create((Object[])new Object[]{"org.palladiosimulator.simulizar"});

    public static <T> Optional<T> getObjectFromStore(ExtensionContext extensionContext, Class<T> clazz) {
        return Optional.ofNullable(extensionContext.getStore(SIMULIZAR).get((Object)clazz.getName(), clazz));
    }

    public static <T> void putObjectIntoStore(ExtensionContext extensionContext, Class<? super T> key, T object) {
        extensionContext.getStore(SIMULIZAR).put((Object)key.getName(), object);
    }

    public static Optional<Object> findModelEntity(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return SimuLizarTestExtensionCommons.getObjectFromStore(extensionContext, PCMResourceSetPartition.class).flatMap(rsp -> {
            Predicate<Object> filter = SimuLizarTestExtensionCommons.getParameterFilterPredicate(parameterContext);
            return Streams.stream((Iterator)EcoreUtil.getAllContents((ResourceSet)rsp.getResourceSet(), (boolean)true)).filter(filter).findAny();
        });
    }

    public static Predicate<Object> getParameterFilterPredicate(ParameterContext parameterContext) {
        Predicate<Object> basePredicate = parameterContext.getParameter().getType()::isInstance;
        return parameterContext.findAnnotation(PredicateFactory.class).map(pf -> {
            try {
                return pf.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }).map(factory -> (Predicate)factory.apply(parameterContext)).map(basePredicate::and).orElse(basePredicate);
    }

    public static <T> T loadInstance(Class<? extends Supplier<T>> supplierClass, ExtensionContext context) {
        try {
            Constructor<?>[] constructorArray = supplierClass.getDeclaredConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constr = constructorArray[n2];
                if (constr.getParameterCount() == 1 && constr.getParameters()[0].getType().isAssignableFrom(ExtensionContext.class)) {
                    return supplierClass.getDeclaredConstructor(ExtensionContext.class).newInstance(context).get();
                }
                ++n2;
            }
            return supplierClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).get();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

