/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.test.commons.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.palladiosimulator.edp2.models.ExperimentData.DataSeries;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MeasurementsUtility;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.metricspec.util.MetricSpecSwitch;
import org.palladiosimulator.simulizar.utils.MonitorRepositoryUtil;

public final class MeasurementTestUtils {
    public static <Q extends Quantity> void allDoubleMeasurementValuesMatch(Measurement measurement, BaseMetricDescription valueMetric, Unit<Q> unit, Matcher<Double> matcher) {
        MeasurementTestUtils.allMeasurementValuesMatch(measurement, valueMetric, org.palladiosimulator.simulizar.test.commons.hamcrest.Matchers.asDoubleIn(unit, matcher));
    }

    public static <Q extends Quantity> void allMeasurementValuesMatch(Measurement measurement, BaseMetricDescription valueMetric, Matcher<Measure<?, Q>> matcher) {
        MatcherAssert.assertThat(MeasurementTestUtils.allMeasurementsOfMetric(measurement, valueMetric), (Matcher)Matchers.everyItem(matcher));
    }

    public static <Q extends Quantity> List<Measure<?, Q>> allMeasurementsOfMetric(Measurement measurement, final BaseMetricDescription valueMetric) {
        Integer dataSeriesIdx = (Integer)new MetricSpecSwitch<Integer>(){
            int index = 0;

            public Integer caseBaseMetricDescription(BaseMetricDescription object) {
                if (object.getId().equals(valueMetric.getId())) {
                    return this.index;
                }
                return -1;
            }

            public Integer caseMetricSetDescription(MetricSetDescription object) {
                int result = -1;
                Iterator subsumedIterator = object.getSubsumedMetrics().iterator();
                while (subsumedIterator.hasNext() && result == -1) {
                    result = (Integer)this.doSwitch((EObject)subsumedIterator.next());
                    ++this.index;
                }
                return result;
            }
        }.doSwitch((EObject)measurement.getMeasuringType().getMetric());
        return measurement.getMeasurementRanges().stream().map(MeasurementRange::getRawMeasurements).map(rm -> (DataSeries)rm.getDataSeries().get(dataSeriesIdx.intValue())).map(ds -> MeasurementsUtility.getMeasurementsDao((DataSeries)ds)).flatMap(dao -> dao.getMeasurements().stream()).collect(Collectors.toList());
    }

    public static Optional<Measurement> getMeasurementOfAt(Collection<Measurement> measurements, MetricDescription metric, EObject location) {
        return measurements.stream().filter(m -> m.getMeasuringType().getMetric().getId().equals(metric.getId()) && m.getMeasuringType().getMeasuringPoint().getResourceURIRepresentation().equals(EcoreUtil.getURI((EObject)location).toString())).findAny();
    }

    public static Optional<Measurement> getMeasurementOfAt(Collection<Measurement> measurements, MetricDescription metric, MeasuringPoint location) {
        return measurements.stream().filter(m -> m.getMeasuringType().getMetric().getId().equals(metric.getId()) && MeasurementTestUtils.sameMeasuringPoint(m.getMeasuringType().getMeasuringPoint(), location)).findAny();
    }

    public static boolean sameMeasuringPoint(MeasuringPoint point1, MeasuringPoint point2) {
        String id1 = MonitorRepositoryUtil.getMeasurementIdentifier((MeasuringPoint)point1);
        String id2 = MonitorRepositoryUtil.getMeasurementIdentifier((MeasuringPoint)point2);
        return id1.equals(id2);
    }

    public static Map<Integer, Double> calculateIntBucketsBasedOnStateDuration(Measurement measurement, BaseMetricDescription contentMetric, Unit<? extends Quantity> convertContentToMetric) {
        HashMap<Integer, Double> result = new HashMap<Integer, Double>();
        Iterator timeIter = MeasurementTestUtils.allMeasurementsOfMetric(measurement, (BaseMetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC).iterator();
        Iterator contentIter = MeasurementTestUtils.allMeasurementsOfMetric(measurement, contentMetric).iterator();
        double lastTime = 0.0;
        int lastVal = 0;
        while (timeIter.hasNext() && contentIter.hasNext()) {
            double thisTime = timeIter.next().doubleValue((Unit)SI.SECOND);
            int thisVal = contentIter.next().intValue(convertContentToMetric);
            double duration = thisTime - lastTime;
            Double prevDuration = result.getOrDefault(lastVal, 0.0);
            result.put(lastVal, prevDuration + duration);
            lastTime = thisTime;
            lastVal = thisVal;
        }
        return result;
    }
}

