/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.test.commons.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.osgi.framework.Bundle;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.simulizar.test.commons.annotation.LoadPCMInstanceFromBundle;

public class LoadPCMInstanceFromBundleSupplier
implements Supplier<PCMResourceSetPartition> {
    final LoadPCMInstanceFromBundle annotation;

    public LoadPCMInstanceFromBundleSupplier(ExtensionContext context) {
        this.annotation = (LoadPCMInstanceFromBundle)context.getElement().flatMap(ae -> Optional.ofNullable(ae.getAnnotation(LoadPCMInstanceFromBundle.class))).orElseThrow(() -> new IllegalArgumentException("Invalid annotation configuration. No annotation of type LoadPCMInstanceFromBundle found."));
    }

    @Override
    public PCMResourceSetPartition get() {
        PCMResourceSetPartition result = new PCMResourceSetPartition();
        Path baseUrl = Path.forPosix((String)this.annotation.basePath());
        List<String> modelFiles = Arrays.asList(this.annotation.modelFiles());
        Bundle bundle = Platform.getBundle((String)this.annotation.bundleName());
        for (String file : modelFiles) {
            IPath path = baseUrl.append(file);
            URL url = FileLocator.find((Bundle)bundle, (IPath)path);
            try {
                URI uri = URI.createURI((String)url.toURI().toString());
                Resource res = result.getResourceSet().createResource(uri);
                res.load(FileLocator.openStream((Bundle)bundle, (IPath)path, (boolean)true), Collections.emptyMap());
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        EcoreUtil.resolveAll((ResourceSet)result.getResourceSet());
        return result;
    }
}

