/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.test.commons.util;

import com.google.common.collect.ImmutableSet;
import de.uka.ipd.sdq.workflow.configuration.IJobConfiguration;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.palladiosimulator.simulizar.core.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.di.base.extension.ExtensionComponent;
import org.palladiosimulator.simulizar.di.component.dependency.SimEngineComponent;
import org.palladiosimulator.simulizar.di.modules.component.extensions.ExtensionComponentsModule;
import org.palladiosimulator.simulizar.di.modules.stateless.core.RootComponentFactoriesModule;
import org.palladiosimulator.simulizar.di.modules.stateless.mdsd.MDSDBlackboardProvidingModule;
import org.palladiosimulator.simulizar.test.commons.annotation.UseSimuLizarExtension;
import org.palladiosimulator.simulizar.test.commons.di.components.DaggerTestSimEngineComponent;
import org.palladiosimulator.simulizar.test.commons.di.components.DaggerTestSimuLizarRootComponent;
import org.palladiosimulator.simulizar.test.commons.di.components.TestSimuLizarRootComponent;
import org.palladiosimulator.simulizar.test.commons.extension.SimuLizarTestExtensionCommons;

public class RunSimuLizarSimulationJobSupplier
implements Supplier<IJob> {
    protected final SimuLizarWorkflowConfiguration configuration;
    protected final MDSDBlackboard blackboard;
    private List<UseSimuLizarExtension> extensions;

    public RunSimuLizarSimulationJobSupplier(ExtensionContext context) {
        this.configuration = SimuLizarTestExtensionCommons.getObjectFromStore(context, IJobConfiguration.class).filter(SimuLizarWorkflowConfiguration.class::isInstance).map(SimuLizarWorkflowConfiguration.class::cast).orElseThrow(() -> new IllegalArgumentException("No SimuLizar Configuration present repository initialized. Please make sure to annotate your test accordingly."));
        this.blackboard = SimuLizarTestExtensionCommons.getObjectFromStore(context, MDSDBlackboard.class).orElseThrow(() -> new IllegalArgumentException("No SimuLizar Blackboard initialized. Please make sure to annotate your test accordingly."));
        this.extensions = AnnotationSupport.findRepeatableAnnotations((Optional)context.getElement(), UseSimuLizarExtension.class);
    }

    @Override
    public IJob get() {
        HashSet<ExtensionComponent.Factory> extensionFactories = new HashSet<ExtensionComponent.Factory>();
        for (UseSimuLizarExtension extension : this.extensions) {
            Class<? extends ExtensionComponent> extCls = extension.value();
            try {
                ExtensionComponent.Factory factory = (ExtensionComponent.Factory)extCls.getMethod("factory", new Class[0]).invoke(null, new Object[0]);
                extensionFactories.add(factory);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Could not create extension factory. Make sure to reference the Dagger generated component class");
            }
        }
        TestSimuLizarRootComponent component = DaggerTestSimuLizarRootComponent.factory().create(this.configuration, new RootComponentFactoriesModule(){

            public SimEngineComponent.Factory providesSimEngineComponentFactory() {
                return DaggerTestSimEngineComponent.factory();
            }
        }, new ExtensionComponentsModule(extensionFactories, (Set)ImmutableSet.of()), new MDSDBlackboardProvidingModule(this.blackboard), new TestSimuLizarRootComponent.TestConfigurationModule(){

            @Override
            public boolean activateModelLoading() {
                return false;
            }
        });
        return component.rootJob();
    }
}

