/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.ui.wizards;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.osgi.framework.Bundle;
import org.palladiosimulator.simulizar.ui.wizards.Activator;

public class ExampleWizardSupport {
    public static IProject createProject(String projectName, URI location, String archivePath) {
        Assert.isNotNull((Object)projectName);
        Assert.isTrue((projectName.trim().length() > 0 ? 1 : 0) != 0);
        IProject project = ExampleWizardSupport.createBaseProject(projectName, location);
        try {
            ExampleWizardSupport.addNature(project);
            ZipFile file = null;
            try {
                Bundle b = Activator.getDefault().getBundle();
                URL u = b.getEntry(archivePath);
                URL ur = FileLocator.toFileURL((URL)u);
                file = new ZipFile(ur.getFile());
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
            ZipFileStructureProvider provider = new ZipFileStructureProvider(file);
            IPath containerPath = project.getFullPath();
            ZipEntry source = provider.getRoot();
            IOverwriteQuery query = new IOverwriteQuery(){

                public String queryOverwrite(String path) {
                    return "ALL";
                }
            };
            ImportOperation operation = new ImportOperation(containerPath, (Object)source, (IImportStructureProvider)provider, query);
            operation.setCreateContainerStructure(true);
            try {
                operation.run(null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            project = null;
        }
        return project;
    }

    private static IProject createBaseProject(String projectName, URI location) {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!newProject.exists()) {
            URI projectLocation = location;
            IProjectDescription desc = newProject.getWorkspace().newProjectDescription(newProject.getName());
            if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(location)) {
                projectLocation = null;
            }
            desc.setLocationURI(projectLocation);
            try {
                newProject.create(desc, null);
                if (!newProject.isOpen()) {
                    newProject.open(null);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return newProject;
    }

    private static void addNature(IProject project) throws CoreException {
        if (!project.hasNature("org.palladiosimulator.simulizar.simulizarNature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.palladiosimulator.simulizar.simulizarNature";
            description.setNatureIds(newNatures);
            IProgressMonitor monitor = null;
            project.setDescription(description, monitor);
        }
    }

    public static void modifyLaunchConfigurationAttributeValues(List<String> attributesKeys, String stringToReplace, String stringThatReplaces, ILaunchConfiguration readOnlyLaunchConfiguration, ILaunchConfigurationWorkingCopy writableLaunchConfiguration) throws CoreException {
        for (String attributeKey : attributesKeys) {
            String attributeValue = readOnlyLaunchConfiguration.getAttribute(attributeKey, "");
            writableLaunchConfiguration.setAttribute(attributeKey, attributeValue.replace(stringToReplace, stringThatReplaces));
        }
        readOnlyLaunchConfiguration.delete();
        writableLaunchConfiguration.doSave();
    }
}

