/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.utilization.probeframework;

import de.uka.ipd.sdq.simucomframework.core.SimuComConfig;
import de.uka.ipd.sdq.simucomframework.core.model.SimuComModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MeasurementsUtility;
import org.palladiosimulator.experimentanalysis.ISlidingWindowListener;
import org.palladiosimulator.experimentanalysis.ISlidingWindowMoveOnStrategy;
import org.palladiosimulator.experimentanalysis.KeepLastElementPriorToLowerBoundStrategy;
import org.palladiosimulator.experimentanalysis.SlidingWindow;
import org.palladiosimulator.experimentanalysis.SlidingWindowRecorder;
import org.palladiosimulator.experimentanalysis.windowaggregators.SlidingWindowUtilizationAggregator;
import org.palladiosimulator.measurementframework.listener.MeasurementSource;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.ProcessingType;
import org.palladiosimulator.monitorrepository.TimeDriven;
import org.palladiosimulator.monitorrepository.util.MonitorRepositorySwitch;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceReference;
import org.palladiosimulator.pcmmeasuringpoint.PcmmeasuringpointPackage;
import org.palladiosimulator.pcmmeasuringpoint.util.PcmmeasuringpointSwitch;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.IObservableCalculatorRegistry;
import org.palladiosimulator.recorderframework.core.IRecorder;
import org.palladiosimulator.recorderframework.core.config.IRecorderConfiguration;
import org.palladiosimulator.recorderframework.edp2.config.EDP2RecorderConfiguration;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementPackage;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractProbeFrameworkListener;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractRecordingProbeFrameworkListenerDecorator;
import org.palladiosimulator.simulizar.slidingwindow.impl.SimulizarSlidingWindow;
import org.palladiosimulator.simulizar.slidingwindow.runtimemeasurement.SlidingWindowRuntimeMeasurementsRecorder;

public class UtilizationProbeFrameworkListenerDecorator
extends AbstractRecordingProbeFrameworkListenerDecorator {
    private static final MetricSetDescription UTILIZATION_TUPLE_METRIC_DESC = MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE;
    private static final BaseMetricDescription UTILIZATION_METRIC_DESC = MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE;
    private static final MetricSetDescription STATE_TUPLE_METRIC_DESC = MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE;
    private static final EClass ACTIVE_RESOURCE_MP_ECLASS = PcmmeasuringpointPackage.Literals.ACTIVE_RESOURCE_MEASURING_POINT;
    private static final MonitorRepositorySwitch<Optional<TimeDriven>> PROCESSING_TYPE_SWITCH = new MonitorRepositorySwitch<Optional<TimeDriven>>(){

        public Optional<TimeDriven> caseTimeDriven(TimeDriven timeDriven) {
            return Optional.of(timeDriven);
        }

        public Optional<TimeDriven> defaultCase(EObject eObject) {
            return Optional.empty();
        }
    };
    private static final PcmmeasuringpointSwitch<Optional<ActiveResourceMeasuringPoint>> ACTIVE_RESOURCE_MP_SWITCH = new PcmmeasuringpointSwitch<Optional<ActiveResourceMeasuringPoint>>(){

        public Optional<ActiveResourceMeasuringPoint> caseActiveResourceMeasuringPoint(ActiveResourceMeasuringPoint activeResourceMeasuringPoint) {
            return Optional.of(activeResourceMeasuringPoint);
        }

        public Optional<ActiveResourceMeasuringPoint> defaultCase(EObject eObject) {
            return Optional.empty();
        }
    };
    private ISlidingWindowMoveOnStrategy moveOnStrategy = null;
    private SimuComModel model = null;
    private RuntimeMeasurementModel rmModel;
    private IObservableCalculatorRegistry calculatorRegistry;

    public void registerMeasurements() {
        super.registerMeasurements();
        ArrayList<MeasurementSpecification> utilMeasurementSpecs = new ArrayList<MeasurementSpecification>(this.getProbeFrameworkListener().getMeasurementSpecificationsForMetricDescription((MetricDescription)UTILIZATION_TUPLE_METRIC_DESC));
        utilMeasurementSpecs.addAll(this.getProbeFrameworkListener().getMeasurementSpecificationsForMetricDescription((MetricDescription)UTILIZATION_METRIC_DESC));
        this.initUtilizationMeasurements(utilMeasurementSpecs);
    }

    public void setProbeFrameworkListener(AbstractProbeFrameworkListener probeFrameworkListener) {
        super.setProbeFrameworkListener(probeFrameworkListener);
        PCMPartitionManager manager = this.getProbeFrameworkListener().getPCMPartitionManager();
        this.rmModel = (RuntimeMeasurementModel)manager.findModel(RuntimeMeasurementPackage.eINSTANCE.getRuntimeMeasurementModel());
        this.model = this.getProbeFrameworkListener().getSimuComModel();
        this.calculatorRegistry = this.getProbeFrameworkContext().getCalculatorRegistry();
    }

    private void initUtilizationMeasurements(Collection<MeasurementSpecification> utilMeasurementSpecs) {
        assert (utilMeasurementSpecs != null);
        if (!utilMeasurementSpecs.isEmpty()) {
            this.moveOnStrategy = new KeepLastElementPriorToLowerBoundStrategy();
            Collection<Calculator> overallUtilizationCalculators = this.getAvailableOverallUtilizationCalculators();
            for (MeasurementSpecification spec : utilMeasurementSpecs) {
                MeasuringPoint mp = spec.getMonitor().getMeasuringPoint();
                Optional activeResourceMp = (Optional)ACTIVE_RESOURCE_MP_SWITCH.doSwitch((EObject)mp);
                Optional<Calculator> overallUtilizationCalculator = activeResourceMp.filter(a -> a.getReplicaID() == 0).map(ActiveResourceReference::getActiveResource).filter(proc -> proc.getNumberOfReplicas() > 1).flatMap(proc -> UtilizationProbeFrameworkListenerDecorator.findOverallUtilizationCalculatorForProcessingResource(proc, overallUtilizationCalculators));
                Optional timeDrivenProcessingType = (Optional)PROCESSING_TYPE_SWITCH.doSwitch((EObject)spec.getProcessingType());
                Calculator stateOfActiveResourceCalculator = this.calculatorRegistry.getCalculatorByMeasuringPointAndMetricDescription(mp, (MetricDescription)STATE_TUPLE_METRIC_DESC);
                UtilizationProbeFrameworkListenerDecorator.checkValidity(spec, timeDrivenProcessingType, stateOfActiveResourceCalculator, mp);
                this.setupUtilizationRecorder(stateOfActiveResourceCalculator, spec, (TimeDriven)timeDrivenProcessingType.get(), overallUtilizationCalculator);
            }
        }
    }

    private Collection<Calculator> getAvailableOverallUtilizationCalculators() {
        Collection overallUtilizationCalculators = this.calculatorRegistry.getRegisteredCalculators().stream().filter(calc -> calc.isCompatibleWith((MetricDescription)UTILIZATION_TUPLE_METRIC_DESC) && ACTIVE_RESOURCE_MP_ECLASS.isInstance((Object)calc.getMeasuringPoint())).collect(Collectors.toList());
        return overallUtilizationCalculators;
    }

    private static Optional<Calculator> findOverallUtilizationCalculatorForProcessingResource(ProcessingResourceSpecification proc, Collection<Calculator> overallUtilizationCalculators) {
        String processingResourceId = proc.getId();
        return overallUtilizationCalculators.stream().filter(calc -> ((ActiveResourceMeasuringPoint)calc.getMeasuringPoint()).getActiveResource().getId().equals(processingResourceId)).findAny();
    }

    private static void checkValidity(MeasurementSpecification utilizationMeasurementSpec, Optional<TimeDriven> aggregation, Calculator stateOfActiveResourceCalculator, MeasuringPoint mp) {
        if (stateOfActiveResourceCalculator == null) {
            throw new IllegalStateException("Utilization measurements (sliding window based) cannot be initialized.\nNo state of active resource calculator available for: " + mp.getStringRepresentation() + "\n" + "Ensure that initializeModelSyncers() in SimulizarRuntimeState is called prior " + "to initializeInterpreterListeners()!");
        }
        if (!aggregation.isPresent()) {
            throw new IllegalStateException("MetricDescription (" + utilizationMeasurementSpec.getMetricDescription().getName() + ") '" + utilizationMeasurementSpec.getName() + "' of Monitor '" + utilizationMeasurementSpec.getMonitor().getEntityName() + "' must provide a " + ProcessingType.class.getName() + " of Type '" + TimeDriven.class.getName() + "'!");
        }
    }

    private void setupUtilizationRecorder(Calculator stateOfActiveResourceCalculator, MeasurementSpecification utilizationMeasurementSpec, TimeDriven timeDrivenProcessingType, Optional<Calculator> overallUtilizationCalculator) {
        this.setupSlidingWindowAggregatorAndRecorder(stateOfActiveResourceCalculator, timeDrivenProcessingType, utilizationMeasurementSpec, STATE_TUPLE_METRIC_DESC, utilizationMeasurementSpec.getMonitor().getMeasuringPoint());
        overallUtilizationCalculator.ifPresent(calc -> this.setupSlidingWindowAggregatorAndRecorder((Calculator)calc, timeDrivenProcessingType, utilizationMeasurementSpec, UTILIZATION_TUPLE_METRIC_DESC, calc.getMeasuringPoint()));
    }

    private void setupSlidingWindowAggregatorAndRecorder(Calculator calc, TimeDriven timeDrivenProcessingType, MeasurementSpecification spec, MetricSetDescription desc, MeasuringPoint measuringPoint) {
        SlidingWindowUtilizationAggregator aggregator = this.createSlidingWindowAggregator(calc, desc);
        this.registerMeasurementsRecorder((MeasurementSource)calc, (IRecorder)this.createSlidingWindowRecorder(timeDrivenProcessingType, aggregator));
        if (spec.isTriggersSelfAdaptations()) {
            aggregator.addRecorder((IRecorder)new SlidingWindowRuntimeMeasurementsRecorder(this.rmModel, spec, measuringPoint));
        }
    }

    private SlidingWindowUtilizationAggregator createSlidingWindowAggregator(Calculator baseCalculator, MetricSetDescription expectedWindowDataMetric) {
        Map recorderConfigMap = UtilizationProbeFrameworkListenerDecorator.createRecorderConfigMapWithAcceptedMetricAndMeasuringPoint((MetricDescription)UTILIZATION_TUPLE_METRIC_DESC, (MeasuringPoint)baseCalculator.getMeasuringPoint());
        return new SlidingWindowUtilizationAggregator((MetricDescription)expectedWindowDataMetric, super.initializeRecorder(recorderConfigMap));
    }

    private SlidingWindowRecorder createSlidingWindowRecorder(TimeDriven timeDrivenProcessingType, SlidingWindowUtilizationAggregator utilizationAggregator) {
        assert (this.model != null && this.rmModel != null && timeDrivenProcessingType != null && utilizationAggregator != null);
        return new SlidingWindowRecorder((SlidingWindow)new SimulizarSlidingWindow(timeDrivenProcessingType.getWindowLengthAsMeasure(), timeDrivenProcessingType.getWindowIncrementAsMeasure(), utilizationAggregator.getExpectedWindowDataMetric(), this.moveOnStrategy, this.model), (ISlidingWindowListener)utilizationAggregator);
    }

    protected IRecorderConfiguration createRecorderConfiguration(SimuComConfig config, Map<String, Object> recorderConfigMap) {
        IRecorderConfiguration recorderConfig = super.createRecorderConfiguration(config, recorderConfigMap);
        if (recorderConfig instanceof EDP2RecorderConfiguration) {
            this.tagMeasurement((EDP2RecorderConfiguration)recorderConfig);
        }
        return recorderConfig;
    }

    private void tagMeasurement(EDP2RecorderConfiguration recorderConfig) {
        assert (recorderConfig != null);
        Measurement measurement = recorderConfig.getMeasurement();
        if (measurement == null) {
            throw new RuntimeException("Measurement null! Something went wrong, as this should have been created by the recorder configuration factory!");
        }
        measurement.getAdditionalInformation().put((Object)"SLIDING_WINDOW_BASED", (Object)MeasurementsUtility.SLIDING_WINDOW_BASED_MEASUREMENT_TAG_VALUE);
    }
}

