/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.modelobserver;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.simucomframework.core.ResourceRegistry;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.core.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.core.resources.CalculatorHelper;
import de.uka.ipd.sdq.simucomframework.core.resources.ScheduledResource;
import de.uka.ipd.sdq.simucomframework.core.resources.SimulatedLinkingResource;
import de.uka.ipd.sdq.simucomframework.core.resources.SimulatedLinkingResourceContainer;
import de.uka.ipd.sdq.simucomframework.core.resources.SimulatedResourceContainer;
import de.uka.ipd.sdq.stoex.StoexPackage;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.pcm.core.CorePackage;
import org.palladiosimulator.pcm.resourceenvironment.CommunicationLinkResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.util.PcmmeasuringpointSwitch;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.di.base.scopes.SimulationRuntimeScope;
import org.palladiosimulator.simulizar.legacy.CalculatorFactoryFacade;
import org.palladiosimulator.simulizar.modelobserver.AbstractResourceEnvironmentObserver;
import org.palladiosimulator.simulizar.utils.MonitorRepositoryUtil;

@SimulationRuntimeScope
public class ResourceEnvironmentSyncer
extends AbstractResourceEnvironmentObserver {
    private static final Logger LOGGER = Logger.getLogger((String)ResourceEnvironmentSyncer.class.getName());
    private static final Set<EStructuralFeature> SUPPORTED_PROCESSING_RESOURCE_STOEX_PROPERTIES = Collections.singleton(ResourceenvironmentPackage.Literals.PROCESSING_RESOURCE_SPECIFICATION__PROCESSING_RATE_PROCESSING_RESOURCE_SPECIFICATION);
    private static final Set<EStructuralFeature> SUPPORTED_LINKING_RESOURCE_STOEX_PROPERTIES = Collections.unmodifiableSet(new HashSet<EReference>(Arrays.asList(ResourceenvironmentPackage.Literals.COMMUNICATION_LINK_RESOURCE_SPECIFICATION__LATENCY_COMMUNICATION_LINK_RESOURCE_SPECIFICATION, ResourceenvironmentPackage.Literals.COMMUNICATION_LINK_RESOURCE_SPECIFICATION__THROUGHPUT_COMMUNICATION_LINK_RESOURCE_SPECIFICATION)));
    private final ResourceRegistry resourceRegistry;
    private Optional<MonitorRepository> monitorRepository;
    private final CalculatorFactoryFacade calcFactory;

    @Inject
    public ResourceEnvironmentSyncer(@PCMPartitionManager.Global PCMResourceSetPartition globalPCMInstance, ResourceRegistry resourceRegistry, CalculatorFactoryFacade calcFactory) {
        super(globalPCMInstance);
        this.resourceRegistry = resourceRegistry;
        this.calcFactory = calcFactory;
    }

    @Override
    public void initialize() {
        this.monitorRepository = this.globalPCMInstance.getElement(MonitorRepositoryPackage.Literals.MONITOR_REPOSITORY).stream().findFirst();
        super.initialize();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Initializing Simulated ResourcesContainer");
        }
        for (ResourceEnvironment resEnv : this.model) {
            resEnv.getResourceContainer_ResourceEnvironment().forEach(this::createSimulatedResourceContainer);
            resEnv.getLinkingResources__ResourceEnvironment().forEach(this::createSimulatedLinkingResource);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Initialization done");
        }
    }

    @Override
    protected void add(Notification notification) {
        ResourceenvironmentPackage resourceenvironmentPackage = ResourceenvironmentPackage.eINSTANCE;
        Object changedFeature = notification.getFeature();
        if (changedFeature == resourceenvironmentPackage.getResourceEnvironment_ResourceContainer_ResourceEnvironment()) {
            this.createSimulatedResourceContainer((ResourceContainer)notification.getNewValue());
        } else if (changedFeature == resourceenvironmentPackage.getResourceContainer_ActiveResourceSpecifications_ResourceContainer()) {
            this.createSimulatedActiveResource((ProcessingResourceSpecification)notification.getNewValue());
        } else if (changedFeature == resourceenvironmentPackage.getResourceEnvironment_LinkingResources__ResourceEnvironment()) {
            this.createSimulatedLinkingResource((LinkingResource)notification.getNewValue());
        } else {
            this.logDebugInfo(notification);
        }
    }

    @Override
    protected void set(Notification notification) {
        boolean handled = ResourceEnvironmentSyncer.syncIfFeatureOrCharacterizingStoExChanged(notification, ProcessingResourceSpecification.class, SUPPORTED_PROCESSING_RESOURCE_STOEX_PROPERTIES, this::syncProcessingResource);
        if (!(handled |= ResourceEnvironmentSyncer.syncIfFeatureOrCharacterizingStoExChanged(notification, CommunicationLinkResourceSpecification.class, SUPPORTED_LINKING_RESOURCE_STOEX_PROPERTIES, this::syncLinkingResource))) {
            this.logDebugInfo(notification);
        }
    }

    private static <T> boolean syncIfFeatureOrCharacterizingStoExChanged(Notification notification, Class<T> clazz, Set<EStructuralFeature> features, Consumer<T> syncFunction) {
        Optional<Object> candidate = Optional.empty();
        if (features.contains(notification.getFeature())) {
            candidate = Optional.of(notification.getNotifier());
        } else if (CorePackage.Literals.PCM_RANDOM_VARIABLE.isInstance(notification.getNotifier()) && StoexPackage.Literals.RANDOM_VARIABLE__SPECIFICATION == notification.getFeature() && (features.contains(((EObject)notification.getNotifier()).eContainmentFeature()) || ResourceEnvironmentSyncer.featureIsOppositeReference(notification.getFeature(), features))) {
            candidate = Optional.of(((EObject)notification.getNotifier()).eContainer());
        }
        return candidate.filter(clazz::isInstance).map(clazz::cast).map(obj -> {
            syncFunction.accept(obj);
            return true;
        }).orElse(false);
    }

    private static boolean featureIsOppositeReference(Object feature, Set<EStructuralFeature> features) {
        return EcorePackage.Literals.EREFERENCE.isInstance(feature) && features.contains(((EObject)feature).eGet((EStructuralFeature)EcorePackage.Literals.EREFERENCE__EOPPOSITE));
    }

    private void createSimulatedResourceContainer(ResourceContainer resourceContainer) {
        if (!this.resourceRegistry.containsResourceContainer(resourceContainer.getId())) {
            AbstractSimulatedResourceContainer simulatedResourceContainer = this.resourceRegistry.createResourceContainer(resourceContainer.getId());
            resourceContainer.getActiveResourceSpecifications_ResourceContainer().forEach(this::createSimulatedActiveResource);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Added SimulatedResourceContainer: ID: " + resourceContainer.getId() + " " + simulatedResourceContainer));
            }
        } else {
            LOGGER.warn((Object)("SimulatedResourceContainer was already present for ID: " + resourceContainer.getId()));
        }
    }

    private void createSimulatedLinkingResource(LinkingResource linkingResource) {
        if (!this.resourceRegistry.containsResourceContainer(linkingResource.getId())) {
            AbstractSimulatedResourceContainer simulatedResourceContainer = this.resourceRegistry.createLinkingResourceContainer(linkingResource.getId());
            if (linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource() != null) {
                this.syncLinkingResource(linkingResource.getCommunicationLinkResourceSpecifications_LinkingResource());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Added SimulatedLinkingResource: ID: " + linkingResource.getId() + " " + simulatedResourceContainer));
            }
        } else {
            LOGGER.warn((Object)("SimulatedLinkingResource was already present for ID: " + linkingResource.getId()));
        }
    }

    private void createSimulatedActiveResource(ProcessingResourceSpecification processingResource) {
        ResourceContainer resourceContainer = processingResource.getResourceContainer_ProcessingResourceSpecification();
        SimulatedResourceContainer simulatedResourceContainer = (SimulatedResourceContainer)this.getSimulatedResourceContainer((Identifier)resourceContainer);
        if (simulatedResourceContainer.getAllActiveResources().containsKey(processingResource.getActiveResourceType_ActiveResourceSpecification().getId())) {
            this.syncProcessingResource(processingResource);
        } else {
            ScheduledResource scheduledResource = simulatedResourceContainer.addActiveResourceWithoutCalculators(processingResource, new String[0], resourceContainer.getId(), processingResource.getSchedulingPolicy().getId());
            scheduledResource.activateResource();
            this.attachMonitors(processingResource, resourceContainer, scheduledResource.getSchedulingStrategyID(), scheduledResource);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Added ActiveResource. TypeID: " + this.getActiveResourceTypeID(processingResource) + ", Description: " + ", SchedulingStrategy: " + scheduledResource.getSchedulingStrategyID()));
            }
        }
    }

    private void syncLinkingResource(CommunicationLinkResourceSpecification resourceSpec) {
        SimulatedLinkingResourceContainer linkContainer = (SimulatedLinkingResourceContainer)this.getSimulatedResourceContainer((Identifier)resourceSpec.getLinkingResource_CommunicationLinkResourceSpecification());
        HashMap activeResources = linkContainer.getAllActiveResources();
        if (activeResources.isEmpty()) {
            linkContainer.addActiveResourceWithoutCalculators(resourceSpec.getLinkingResource_CommunicationLinkResourceSpecification(), linkContainer.getResourceContainerID());
        } else {
            AbstractScheduledResource resource = Optional.ofNullable((AbstractScheduledResource)activeResources.get(resourceSpec.getCommunicationLinkResourceType_CommunicationLinkResourceSpecification().getId())).orElseThrow(() -> new IllegalStateException(String.format("The %s currently does not support changing the resource type of a linking resource", this.getClass())));
            if (resource instanceof SimulatedLinkingResource) {
                SimulatedLinkingResource linkResource = (SimulatedLinkingResource)resource;
                linkResource.setLatency(resourceSpec.getLatency_CommunicationLinkResourceSpecification().getSpecification());
                linkResource.setThroughput(resourceSpec.getThroughput_CommunicationLinkResourceSpecification().getSpecification());
            } else {
                LOGGER.warn((Object)String.format("Update of linking resource parameters failed due to unsupported resource implementation %s", resource.getClass()));
            }
        }
    }

    private void syncProcessingResource(ProcessingResourceSpecification processingResourceSpecification) {
        this.getScheduledResource(processingResourceSpecification).setProcessingRate(processingResourceSpecification.getProcessingRate_ProcessingResourceSpecification().getSpecification());
    }

    private String getActiveResourceTypeID(ProcessingResourceSpecification processingResource) {
        return processingResource.getActiveResourceType_ActiveResourceSpecification().getId();
    }

    private AbstractSimulatedResourceContainer getSimulatedResourceContainer(Identifier container) {
        return this.resourceRegistry.getResourceContainer(container.getId());
    }

    private ScheduledResource getScheduledResource(ProcessingResourceSpecification processingResource) {
        String typeId = this.getActiveResourceTypeID(processingResource);
        return Optional.ofNullable((AbstractScheduledResource)this.getSimulatedResourceContainer((Identifier)processingResource.getResourceContainer_ProcessingResourceSpecification()).getAllActiveResources().get(typeId)).filter(ScheduledResource.class::isInstance).map(ScheduledResource.class::cast).orElseThrow(() -> new NoSuchElementException("Did not find scheduled resource for type ID " + typeId));
    }

    private void attachMonitors(ProcessingResourceSpecification processingResource, final ResourceContainer resourceContainer, final String schedulingStrategy, final ScheduledResource scheduledResource) {
        this.monitorRepository.ifPresent(repo -> {
            for (final MeasurementSpecification measurementSpecification : MonitorRepositoryUtil.getMeasurementSpecificationsForElement(repo, (EObject)processingResource)) {
                new PcmmeasuringpointSwitch<Calculator>(){

                    public Calculator caseActiveResourceMeasuringPoint(ActiveResourceMeasuringPoint activeResourceMeasuringPoint) {
                        return ResourceEnvironmentSyncer.this.attachMonitorForActiveResourceMeasuringPoint(activeResourceMeasuringPoint, measurementSpecification, resourceContainer, scheduledResource, schedulingStrategy);
                    }
                }.doSwitch((EObject)measurementSpecification.getMonitor().getMeasuringPoint());
            }
        });
    }

    private Calculator attachMonitorForActiveResourceMeasuringPoint(ActiveResourceMeasuringPoint activeResourceMeasuringPoint, MeasurementSpecification measurementSpecification, ResourceContainer resourceContainer, ScheduledResource scheduledResource, String schedulingStrategy) {
        Calculator result = null;
        MetricDescription metric = measurementSpecification.getMetricDescription();
        if (MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)metric, (MetricDescription)MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC)) {
            if (!MonitorRepositoryPackage.Literals.FEED_THROUGH.isInstance((Object)measurementSpecification.getProcessingType())) {
                throw new IllegalArgumentException("MetricDescription (" + MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC.getName() + ") '" + measurementSpecification.getName() + "' of Monitor '" + measurementSpecification.getMonitor().getEntityName() + "' must provide a " + MonitorRepositoryPackage.Literals.PROCESSING_TYPE.getName() + " of Type '" + MonitorRepositoryPackage.Literals.FEED_THROUGH.getName() + "'!");
            }
            if (activeResourceMeasuringPoint.getReplicaID() == 0 && scheduledResource.getNumberOfInstances() > 1) {
                this.includeOverallUtilizationCalculator(scheduledResource);
            }
            if (schedulingStrategy.equals("DELAY") || schedulingStrategy.equals("FCFS")) {
                assert (scheduledResource.getNumberOfInstances() == 1) : "DELAY and FCFS resources are expected to have exactly one core";
                result = this.calcFactory.setupActiveResourceStateCalculator((AbstractScheduledResource)scheduledResource, (MeasuringPoint)activeResourceMeasuringPoint, 0);
            } else {
                result = this.calcFactory.setupActiveResourceStateCalculator((AbstractScheduledResource)scheduledResource, (MeasuringPoint)activeResourceMeasuringPoint, activeResourceMeasuringPoint.getReplicaID());
            }
        } else if (!MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)metric, (MetricDescription)MetricDescriptionConstants.WAITING_TIME_METRIC) && !MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)metric, (MetricDescription)MetricDescriptionConstants.HOLDING_TIME_METRIC) && MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)metric, (MetricDescription)MetricDescriptionConstants.RESOURCE_DEMAND_METRIC)) {
            result = this.calcFactory.setupDemandCalculator((AbstractScheduledResource)scheduledResource, (MeasuringPoint)activeResourceMeasuringPoint);
        }
        return result;
    }

    private void includeOverallUtilizationCalculator(ScheduledResource scheduledResource) {
        MeasuringPoint utilization = CalculatorHelper.createMeasuringPoint((AbstractScheduledResource)scheduledResource, (int)scheduledResource.getNumberOfInstances());
        this.calcFactory.setupOverallUtilizationCalculator((AbstractScheduledResource)scheduledResource, utilization);
    }
}

