/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.di.extension;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import dagger.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.palladiosimulator.simulizar.di.base.extension.ExtensionComponent;

public class GenericComponentFactory<ComponentType>
implements Supplier<ComponentType> {
    private Class<ComponentType> componentType;
    private Map<Class<?>, Supplier<?>> suppliers = new HashMap();
    private Set<Class<?>> unfullfilledRequirements;
    private Supplier<ComponentType> daggerComponentFactory;

    public GenericComponentFactory(ExtensionComponent.Factory daggerComponentFactory) {
        Class<?> factoryClass = daggerComponentFactory.getClass();
        if (factoryClass.getInterfaces().length != 1) {
            throw new IllegalStateException("The following logic assumes the concrete factory to solely implement the component factory interface. If this assumption does not hold anymore, this logic needs to be adapted.");
        }
        Class<?> factoryInterface = factoryClass.getInterfaces()[0];
        Component.Factory factoryAnnotation = factoryInterface.getAnnotation(Component.Factory.class);
        if (factoryAnnotation == null) {
            throw new IllegalStateException("The dynamic extension concept currently relies on Dagger Factories");
        }
        this.componentType = factoryInterface.getEnclosingClass();
        Component componentAnnotation = this.componentType.getAnnotation(Component.class);
        this.unfullfilledRequirements = new HashSet<Class>(Arrays.asList(componentAnnotation.dependencies()));
        Optional<Method> factoryMethod = Arrays.asList(factoryInterface.getDeclaredMethods()).stream().filter(m -> this.componentType.isAssignableFrom(m.getReturnType()) && this.requirementsFullfillFactoryMethod((Method)m, this.unfullfilledRequirements)).findAny();
        if (factoryMethod.isEmpty()) {
            throw new IllegalStateException("No compatible factory method found on interface " + factoryInterface.getName());
        }
        this.daggerComponentFactory = () -> {
            Method method = (Method)factoryMethod.get();
            Parameter[] parameterTypes = method.getParameters();
            Object[] parameters = new Object[parameterTypes.length];
            int i = 0;
            while (i < parameterTypes.length) {
                parameters[i] = this.suppliers.get(parameterTypes[i].getType()).get();
                ++i;
            }
            try {
                return ((Method)factoryMethod.get()).invoke((Object)daggerComponentFactory, parameters);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private boolean requirementsFullfillFactoryMethod(Method m, Set<Class<?>> requirements) {
        Set set = Arrays.asList(m.getParameters()).stream().map(Parameter::getType).collect(Collectors.toSet());
        return Sets.difference(set, this.unfullfilledRequirements).isEmpty();
    }

    public Set<Class<?>> getProvidedComponentTypes() {
        return Streams.stream(GenericComponentFactory.getClassHierarchy(this.componentType)).filter(cls -> cls.getAnnotation(Component.class) != null).collect(Collectors.toSet());
    }

    public Set<Class<?>> getUnfullfilledRequirements() {
        return ImmutableSet.copyOf(this.unfullfilledRequirements);
    }

    public <T> void fulfillRequirement(Supplier<T> factory) {
        Stream<Object> providedTypes = null;
        Supplier<Object> realFactory = null;
        if (factory instanceof GenericComponentFactory) {
            providedTypes = ((GenericComponentFactory)factory).getProvidedComponentTypes().stream();
            realFactory = factory;
        } else {
            Object object = factory.get();
            realFactory = () -> object;
            providedTypes = Streams.stream(GenericComponentFactory.getClassHierarchy(object.getClass())).filter(cls -> cls.getAnnotation(Component.class) != null);
        }
        Supplier<Object> finalFactory = realFactory;
        providedTypes.forEach(cls -> {
            boolean requirement = this.unfullfilledRequirements.remove(cls);
            if (requirement) {
                this.suppliers.put((Class<?>)cls, finalFactory);
            }
        });
    }

    @Override
    public ComponentType get() {
        return this.daggerComponentFactory.get();
    }

    public static Iterable<Class<?>> getClassHierarchy(Class<?> baseClass) {
        return Traverser.forGraph(node -> {
            Class superclass = node.getSuperclass();
            List<Class<?>> interfaces = Arrays.asList(node.getInterfaces());
            return superclass == null ? interfaces : Iterables.concat(interfaces, Collections.singleton(superclass));
        }).breadthFirst(baseClass);
    }
}

