/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter.linking.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.simulizar.core.entity.EntityReference;
import org.palladiosimulator.simulizar.core.entity.EntityReferenceFactory;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.di.base.scopes.SimulationRuntimeScope;
import org.palladiosimulator.simulizar.interpreter.linking.ILinkingResourceRouter;

@SimulationRuntimeScope
public class ResourceEnvironmentObservingLegacyRouter
implements ILinkingResourceRouter<EntityReference<ResourceContainer>, EntityReference<LinkingResource>> {
    private final Collection<String> linkingResources = new LinkedList<String>();
    private final Map<String, Set<String>> linkContainerAllocation = new HashMap<String, Set<String>>();
    private final EntityReferenceFactory<LinkingResource> linkReferenceFactory;

    @Inject
    ResourceEnvironmentObservingLegacyRouter(@PCMPartitionManager.Global PCMResourceSetPartition partition, EntityReferenceFactory<LinkingResource> linkReferenceFactory) {
        this.linkReferenceFactory = linkReferenceFactory;
        partition.getElement(ResourceenvironmentPackage.Literals.RESOURCE_ENVIRONMENT).stream().filter(ResourceEnvironment.class::isInstance).forEach(eo -> {
            eo.eAdapters().add((Object)new EContentAdapter(){

                public void notifyChanged(Notification msg) {
                    ResourceEnvironmentObservingLegacyRouter.this.handleNotification(msg);
                    super.notifyChanged(msg);
                }
            });
            this.initialize((ResourceEnvironment)eo);
        });
    }

    @Override
    public Optional<Iterable<EntityReference<LinkingResource>>> findRoute(EntityReference<ResourceContainer> transmissionSource, EntityReference<ResourceContainer> transmissionTarget) {
        if (transmissionSource.equals(transmissionTarget)) {
            return Optional.of(Collections.emptyList());
        }
        for (String link : this.linkingResources) {
            Set containers = this.linkContainerAllocation.getOrDefault(link, Collections.emptySet());
            if (!containers.contains(transmissionSource.getId()) || !containers.contains(transmissionTarget.getId())) continue;
            return Optional.of(Collections.singleton(this.linkReferenceFactory.create(link)));
        }
        return Optional.empty();
    }

    protected void handleNotification(Notification msg) {
        if (msg.getFeature() == ResourceenvironmentPackage.Literals.RESOURCE_ENVIRONMENT__LINKING_RESOURCES_RESOURCE_ENVIRONMENT) {
            this.handleLinkingResourcesChange(msg);
        } else if (msg.getFeature() == ResourceenvironmentPackage.Literals.LINKING_RESOURCE__CONNECTED_RESOURCE_CONTAINERS_LINKING_RESOURCE) {
            this.handleConnectedResourceContainersChange(msg);
        }
    }

    protected void initialize(ResourceEnvironment env) {
        env.getLinkingResources__ResourceEnvironment().forEach(this::doAddLinkingResource);
    }

    protected void handleLinkingResourcesChange(Notification msg) {
        switch (msg.getEventType()) {
            case 3: {
                this.doAddLinkingResource((LinkingResource)msg.getNewValue());
                break;
            }
            case 5: {
                ((Collection)msg.getNewValue()).forEach(this::doAddLinkingResource);
                break;
            }
            case 4: {
                this.doRemoveLinkingResource((LinkingResource)msg.getOldValue());
                break;
            }
            case 6: {
                ((Collection)msg.getOldValue()).forEach(this::doRemoveLinkingResource);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The event type %d is not supported for changes of feature %s by %s", msg.getEventType(), msg.getFeature().toString(), this.getClass().getName()));
            }
        }
    }

    protected void handleConnectedResourceContainersChange(Notification msg) {
        LinkingResource link = (LinkingResource)msg.getNotifier();
        switch (msg.getEventType()) {
            case 3: {
                this.doAddConnectedResourceContainer(link, (ResourceContainer)msg.getNewValue());
                break;
            }
            case 5: {
                ((Collection)msg.getNewValue()).forEach(c -> this.doAddConnectedResourceContainer(link, (ResourceContainer)c));
                break;
            }
            case 4: {
                this.doRemoveConnectedResourceContainer(link, (ResourceContainer)msg.getOldValue());
                break;
            }
            case 6: {
                ((Collection)msg.getNewValue()).forEach(c -> this.doRemoveConnectedResourceContainer(link, (ResourceContainer)c));
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The event type %d is not supported for changes of feature %s by %s", msg.getEventType(), msg.getFeature().toString(), this.getClass().getName()));
            }
        }
    }

    protected void doAddLinkingResource(LinkingResource link) {
        this.linkingResources.add(link.getId());
        link.getConnectedResourceContainers_LinkingResource().forEach(c -> this.doAddConnectedResourceContainer(link, (ResourceContainer)c));
    }

    protected void doRemoveLinkingResource(LinkingResource link) {
        this.linkingResources.remove(link.getId());
        this.linkContainerAllocation.remove(link.getId());
    }

    protected void doAddConnectedResourceContainer(LinkingResource link, ResourceContainer container) {
        this.linkContainerAllocation.computeIfAbsent(link.getId(), k -> new HashSet()).add(container.getId());
    }

    protected void doRemoveConnectedResourceContainer(LinkingResource link, ResourceContainer container) {
        this.linkContainerAllocation.getOrDefault(container.getId(), Collections.emptySet()).remove(container.getId());
    }
}

