/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.commons.eclipseutils.FileHelper;
import org.palladiosimulator.simulizar.core.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.di.base.extension.Extension;
import org.palladiosimulator.simulizar.reconfigurationrule.ModelTransformation;

public abstract class AbstractReconfigurationLoader
implements Extension {
    private static final Logger LOGGER = Logger.getLogger((String)AbstractReconfigurationLoader.class.getName());
    protected final List<ModelTransformation<? extends Object>> transformations = new ArrayList<ModelTransformation<? extends Object>>();

    public void load(SimuLizarWorkflowConfiguration configuration) {
        String reconfFolder = configuration.getReconfigurationRulesFolder();
        if (reconfFolder == null || reconfFolder.isEmpty()) {
            LOGGER.info((Object)"No reconfiguration rules folder specified, reconfigurations disabled.");
            return;
        }
        this.load(reconfFolder);
    }

    private void load(String reconfFolder) {
        URI[] transURIs = FileHelper.getURIs((String)reconfFolder, (String)this.getTransformationFileExtension());
        if (transURIs.length == 0) {
            LOGGER.info((Object)String.format("No transformations with extension %s was found.", this.getTransformationFileExtension()));
            return;
        }
        this.setTransformations(transURIs);
    }

    public List<ModelTransformation<? extends Object>> getTransformations() {
        return this.transformations;
    }

    protected abstract String getTransformationFileExtension();

    protected abstract void setTransformations(URI[] var1);
}

