/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.usagemodel;

import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEventFactory;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationTimeProvider;
import java.util.Optional;
import javax.inject.Named;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.simulizar.core.entity.EntityReference;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.usagemodel.PeriodicallyTriggeredUsageEvolver;
import tools.descartes.dlim.generator.ModelEvaluator;

public class StretchedUsageEvolver
extends PeriodicallyTriggeredUsageEvolver {
    private final double timeFactor;
    private static final double DELTA = 1.0E-6;

    @AssistedInject
    public StretchedUsageEvolver(@Assisted double firstOccurrence, @Assisted double delay, @Assisted EntityReference<UsageScenario> evolvedScenario, @Named(value="maxSimTime") @Named(value="maxSimTime") Optional<Double> maxSimTime, @PCMPartitionManager.Global PCMResourceSetPartition pcmPartition, ISimEventFactory simEventFactory, ISimulationTimeProvider timeProvider) {
        super(firstOccurrence, delay, evolvedScenario, pcmPartition, simEventFactory, timeProvider);
        if (maxSimTime.isEmpty()) {
            throw new IllegalArgumentException("Initializing a streched usage evolver requires a specified maximum simulation time");
        }
        this.timeFactor = maxSimTime.get() / this.getDLIMFinalDuration();
        this.setDelay(delay / this.timeFactor);
    }

    @Override
    protected double getNewRate(ModelEvaluator loadEvaluator) {
        double evaluationTime = this.getCurrentTime() / this.timeFactor;
        if (evaluationTime >= this.getDLIMFinalDuration() - 1.0E-6) {
            return loadEvaluator.getArrivalRateAtTime(evaluationTime - 1.0E-6);
        }
        return loadEvaluator.getArrivalRateAtTime(this.getCurrentTime() / this.timeFactor);
    }
}

