/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.action.jobs;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.extension.AbstractExtensionJobConfiguration;
import de.uka.ipd.sdq.workflow.extension.AbstractWorkflowExtensionJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.simulizar.action.jobs.config.LoadAdaptationBehaviorRepositoryIntoBlackboardJobConfig;
import org.palladiosimulator.simulizar.action.partitions.AdaptationBehaviorRepositoryResourceSetPartition;

public class LoadAdaptationBehaviorRepositoryIntoBlackBoardJob
extends AbstractWorkflowExtensionJob<MDSDBlackboard> {
    private static final String ADAPTATION_BEHAVIOR__REPOSITORY_MODEL_PARTITION_ID = "org.palladiosimulator.simulizar.action";
    private String path;

    public void setJobConfiguration(AbstractExtensionJobConfiguration configuration) throws IllegalArgumentException {
        if (!(configuration instanceof LoadAdaptationBehaviorRepositoryIntoBlackboardJobConfig)) {
            throw new IllegalArgumentException("Given configuration must be of type 'LoadActionRepositoryIntoBlackboardJobConfig'.");
        }
        this.path = ((LoadAdaptationBehaviorRepositoryIntoBlackboardJobConfig)configuration).getAdaptationBehaviorRepositoryPath();
        super.setJobConfiguration(configuration);
    }

    public void setBlackboard(MDSDBlackboard blackboard) throws IllegalArgumentException {
        if (blackboard == null) {
            throw new IllegalArgumentException("Blackboard to set must not be null.");
        }
        super.setBlackboard((Blackboard)blackboard);
    }

    public MDSDBlackboard getBlackboard() {
        return (MDSDBlackboard)this.myBlackboard;
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }

    public void execute(IProgressMonitor arg0) throws JobFailedException, UserCanceledException {
        if (this.myBlackboard == null) {
            throw new IllegalStateException("Blackboard has been not set beforehand!");
        }
        AdaptationBehaviorRepositoryResourceSetPartition partition = new AdaptationBehaviorRepositoryResourceSetPartition();
        if (!this.path.equals("")) {
            partition.loadModel(URI.createURI((String)(!this.path.startsWith("platform:") ? "file:///" + this.path : this.path)));
        }
        ((MDSDBlackboard)this.myBlackboard).addPartition(ADAPTATION_BEHAVIOR__REPOSITORY_MODEL_PARTITION_ID, (Object)partition);
        partition.resolveAllProxies();
    }

    public String getName() {
        return "Perform Adaptation Behavior Repository Load";
    }
}

