/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.storydiagram;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.simulizar.access.IModelAccess;
import org.palladiosimulator.simulizar.reconfiguration.AbstractReconfigurator;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurator;
import org.palladiosimulator.simulizar.reconfiguration.storydiagram.SDExecutor;
import org.palladiosimulator.simulizar.reconfiguration.storydiagram.modelaccess.StoryDiagramModelAccess;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;

public class SDReconfigurator
extends AbstractReconfigurator
implements IReconfigurator {
    private static final Logger LOGGER = Logger.getLogger(SDReconfigurator.class);
    private StoryDiagramModelAccess modelAccess;
    private SDExecutor sdExecutor;
    private SimuLizarWorkflowConfiguration configuration;

    public boolean checkAndExecute(EObject monitoredElement) {
        if (!this.modelAccess.getStoryDiagrams().isEmpty()) {
            LOGGER.debug((Object)"Checking reconfiguration rules due to RuntimeMeasurement change");
            boolean result = this.getSDExecutor().executeActivities(monitoredElement);
            LOGGER.debug((Object)(result ? "Reconfigured system by a matching rule" : "No reconfiguration rule was executed, all conditions were false"));
            return result;
        }
        return false;
    }

    private SDExecutor getSDExecutor() {
        if (this.sdExecutor == null) {
            this.sdExecutor = new SDExecutor(this.modelAccess);
        }
        return this.sdExecutor;
    }

    public void setModelAccess(IModelAccess modelAccess) {
        this.modelAccess = new StoryDiagramModelAccess(modelAccess, this.configuration);
    }

    public void setConfiguration(SimuLizarWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }
}

