/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.reconfiguration.storydiagram.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.simulizar.reconfiguration.storydiagram.modelaccess.SDMResourceSetPartition;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;

public class LoadSDMModelsIntoBlackboardJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    public static final String STORYDIAGRAMS_FILE_EXTENSION = ".sdm";
    public static final String SDM_MODEL_PARTITION_ID = "org.palladiosimulator.simulizar.reconfiguration.sdm";
    private final String path;
    private MDSDBlackboard blackboard;
    private static final Logger LOGGER = Logger.getLogger(LoadSDMModelsIntoBlackboardJob.class);

    public LoadSDMModelsIntoBlackboardJob(SimuLizarWorkflowConfiguration configuration) {
        this.path = configuration.getReconfigurationRulesFolder();
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        SDMResourceSetPartition sdmPartition = new SDMResourceSetPartition();
        this.blackboard.addPartition(SDM_MODEL_PARTITION_ID, (Object)sdmPartition);
        if (this.path != null && !this.path.equals("")) {
            String filePath = this.path;
            File folder = null;
            if (!this.path.startsWith("platform:")) {
                filePath = "file:///" + filePath;
                URI pathToSDM = URI.createURI((String)filePath);
                folder = new File(pathToSDM.toFileString());
            } else {
                String folderString = "";
                try {
                    URL pathURL = FileLocator.resolve((URL)new URL(this.path));
                    folderString = pathURL.toExternalForm().replace("file:", "");
                    folder = new File(folderString);
                }
                catch (IOException e) {
                    LOGGER.warn((Object)("Folder " + folderString + " cannot be accessed."), (Throwable)e);
                    return;
                }
            }
            if (!folder.exists()) {
                LOGGER.warn((Object)("Folder " + folder + " does not exist. No reconfiguration rules will be loaded."));
                return;
            }
            File[] files = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(LoadSDMModelsIntoBlackboardJob.STORYDIAGRAMS_FILE_EXTENSION);
                }
            });
            if (files != null && files.length > 0) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    sdmPartition.loadModel(URI.createFileURI((String)file.getPath()));
                    ++n2;
                }
            } else {
                LOGGER.info((Object)"No SDM models found, SD reconfigurations disabled.");
            }
        }
    }

    public String getName() {
        return "Perform SDM Models Load";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

