/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.access;

import de.uka.ipd.sdq.stoex.StoexPackage;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.commons.emfutils.EMFCopyHelper;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryPackage;
import org.palladiosimulator.pcm.PcmPackage;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementFactory;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjectiveRepository;
import org.palladiosimulator.servicelevelobjective.ServicelevelObjectivePackage;
import org.palladiosimulator.simulizar.access.IModelAccess;
import org.scaledl.usageevolution.UsageEvolution;
import org.scaledl.usageevolution.UsageevolutionPackage;

public class ModelAccess
implements IModelAccess {
    private static final Logger LOGGER = Logger.getLogger((String)ModelAccess.class.getName());
    private final PCMResourceSetPartition pcmPartition;
    private final RuntimeMeasurementModel runtimeMeasurementModel;
    private final MDSDBlackboard blackboard;
    private boolean isObservingPcmChanges = false;
    private PCMResourceSetPartition currentPCMCopy;
    private boolean modelsDirty = false;
    private final Adapter globalPCMChangeListener = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (this.isPCMModel(notification.getFeature()) && notification.getEventType() != 8) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Detected change in global PCM model. Changed object: " + notification.getNotifier()));
                    LOGGER.debug((Object)notification.toString());
                }
                ModelAccess.this.modelsDirty = true;
            }
        }

        private boolean isPCMModel(Object feature) {
            EStructuralFeature eStructFeature;
            EClass containingClass;
            EObject rootContainer;
            return EcorePackage.eINSTANCE.getEObject().isInstance(feature) && EcorePackage.eINSTANCE.getEStructuralFeature().isInstance(feature) && (PcmPackage.eINSTANCE == (rootContainer = EcoreUtil.getRootContainer((EObject)(containingClass = (eStructFeature = (EStructuralFeature)feature).getEContainingClass()))) || StoexPackage.eINSTANCE == rootContainer);
        }
    };

    public ModelAccess(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
        this.runtimeMeasurementModel = RuntimeMeasurementFactory.eINSTANCE.createRuntimeMeasurementModel();
        this.pcmPartition = (PCMResourceSetPartition)this.getResourceSetPartition(blackboard, "org.palladiosimulator.pcmmodels.partition");
        this.currentPCMCopy = this.copyPCMPartition();
    }

    private ModelAccess(ModelAccess copy) {
        this.blackboard = copy.blackboard;
        this.runtimeMeasurementModel = copy.runtimeMeasurementModel;
        this.pcmPartition = copy.pcmPartition;
        copy.checkAndHandleDeferredChanges();
        this.currentPCMCopy = copy.currentPCMCopy;
    }

    @Override
    public IModelAccess clone() {
        return new ModelAccess(this);
    }

    @Override
    public PCMResourceSetPartition getLocalPCMModel() {
        this.checkAndHandleDeferredChanges();
        return this.currentPCMCopy;
    }

    private void checkAndHandleDeferredChanges() {
        if (this.modelsDirty) {
            this.currentPCMCopy = this.copyPCMPartition();
            this.modelsDirty = false;
        }
    }

    public void startObservingPcmChanges() {
        if (!this.isObservingPcmChanges) {
            EList adapters = this.pcmPartition.getResourceSet().eAdapters();
            if (!adapters.contains(this.globalPCMChangeListener)) {
                adapters.add(this.globalPCMChangeListener);
            }
            this.isObservingPcmChanges = true;
        }
    }

    public void stopObservingPcmChanges() {
        if (this.isObservingPcmChanges) {
            this.pcmPartition.getResourceSet().eAdapters().remove((Object)this.globalPCMChangeListener);
            this.isObservingPcmChanges = false;
        }
    }

    protected PCMResourceSetPartition copyPCMPartition() {
        LOGGER.debug((Object)"Take a new copy of the global PCM for new simulation threads");
        PCMResourceSetPartition newPartition = new PCMResourceSetPartition();
        List modelCopy = EMFCopyHelper.deepCopyToEObjectList((ResourceSet)this.pcmPartition.getResourceSet());
        int i = 0;
        while (i < modelCopy.size()) {
            Resource resource = newPartition.getResourceSet().createResource(URI.createFileURI((String)("/temp" + i)));
            resource.getContents().add((Object)((EObject)modelCopy.get(i)));
            ++i;
        }
        return newPartition;
    }

    @Override
    public PCMResourceSetPartition getGlobalPCMModel() {
        return this.pcmPartition;
    }

    @Override
    public MonitorRepository getMonitorRepositoryModel() {
        try {
            LOGGER.debug((Object)"Retrieving Monitor Repository model from blackboard partition");
            List result = this.pcmPartition.getElement(MonitorRepositoryPackage.eINSTANCE.getMonitorRepository());
            return (MonitorRepository)result.get(0);
        }
        catch (Exception e) {
            LOGGER.info((Object)"No Monitor Repository model found, so no simulation data will be taken.");
            return null;
        }
    }

    public ServiceLevelObjectiveRepository getServiceLevelObjectiveRepositoryModel() {
        try {
            LOGGER.debug((Object)"Retrieving Service Level Objective repository from blackboard partition");
            List result = this.pcmPartition.getElement(ServicelevelObjectivePackage.eINSTANCE.getServiceLevelObjectiveRepository());
            return (ServiceLevelObjectiveRepository)result.get(0);
        }
        catch (Exception e) {
            LOGGER.info((Object)"No Service Level Objectives found.");
            return null;
        }
    }

    @Override
    public RuntimeMeasurementModel getRuntimeMeasurementModel() {
        return this.runtimeMeasurementModel;
    }

    @Override
    public UsageEvolution getUsageEvolutionModel() {
        try {
            LOGGER.debug((Object)"Retrieving Usage Evolution model from blackboard partition");
            List result = this.pcmPartition.getElement(UsageevolutionPackage.eINSTANCE.getUsageEvolution());
            return (UsageEvolution)result.get(0);
        }
        catch (Exception e) {
            LOGGER.info((Object)"No Usage Evolution model found, so evolution will not be simulated.");
            return null;
        }
    }

    private <T extends ResourceSetPartition> T getResourceSetPartition(MDSDBlackboard blackboard, String id) {
        return (T)((ResourceSetPartition)blackboard.getPartition(id));
    }

    @Override
    public MDSDBlackboard getBlackboard() {
        return this.blackboard;
    }
}

