/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter;

import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.AssemblyInfrastructureConnector;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.composition.util.CompositionSwitch;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.RepositoryComponentSwitch;

class ComposedStructureInnerSwitch
extends CompositionSwitch<SimulatedStackframe<Object>> {
    protected static final Logger LOGGER = Logger.getLogger((String)ComposedStructureInnerSwitch.class.getName());
    private final InterpreterDefaultContext context;
    private final Signature signature;
    private final RequiredRole requiredRole;

    public ComposedStructureInnerSwitch(InterpreterDefaultContext context, Signature operationSignature, RequiredRole requiredRole) {
        this.context = context;
        this.signature = operationSignature;
        this.requiredRole = requiredRole;
    }

    public SimulatedStackframe<Object> caseAssemblyConnector(AssemblyConnector assemblyConnector) {
        RepositoryComponentSwitch repositoryComponentSwitch = new RepositoryComponentSwitch(this.context, assemblyConnector.getProvidingAssemblyContext_AssemblyConnector(), this.signature, (ProvidedRole)assemblyConnector.getProvidedRole_AssemblyConnector());
        return (SimulatedStackframe)repositoryComponentSwitch.doSwitch((EObject)assemblyConnector.getProvidedRole_AssemblyConnector());
    }

    public SimulatedStackframe<Object> caseAssemblyInfrastructureConnector(AssemblyInfrastructureConnector assemblyInfrastructureConnector) {
        RepositoryComponentSwitch repositoryComponentSwitch = new RepositoryComponentSwitch(this.context, assemblyInfrastructureConnector.getProvidingAssemblyContext__AssemblyInfrastructureConnector(), this.signature, (ProvidedRole)assemblyInfrastructureConnector.getProvidedRole__AssemblyInfrastructureConnector());
        return (SimulatedStackframe)repositoryComponentSwitch.doSwitch((EObject)assemblyInfrastructureConnector.getProvidedRole__AssemblyInfrastructureConnector());
    }

    public SimulatedStackframe<Object> caseRequiredDelegationConnector(RequiredDelegationConnector requiredDelegationConnector) {
        AssemblyContext parentContext = this.context.getAssemblyContextStack().pop();
        ComposedStructureInnerSwitch composedStructureInnerSwitch = new ComposedStructureInnerSwitch(this.context, this.signature, (RequiredRole)requiredDelegationConnector.getOuterRequiredRole_RequiredDelegationConnector());
        SimulatedStackframe result = (SimulatedStackframe)composedStructureInnerSwitch.doSwitch((EObject)parentContext);
        this.context.getAssemblyContextStack().push(parentContext);
        return result;
    }

    public SimulatedStackframe<Object> caseAssemblyContext(AssemblyContext assemblyContext) {
        Connector connector = ComposedStructureInnerSwitch.getConnectedConnector(assemblyContext, this.requiredRole);
        return (SimulatedStackframe)this.doSwitch((EObject)connector);
    }

    private static Connector getConnectedConnector(final AssemblyContext myContext, final RequiredRole requiredRole) {
        if (myContext == null) {
            throw new IllegalArgumentException("Assembly context must not be null");
        }
        if (requiredRole == null) {
            throw new IllegalArgumentException("Required role must not be null");
        }
        CompositionSwitch<Connector> connectorSelector = new CompositionSwitch<Connector>(){

            public Connector caseRequiredDelegationConnector(RequiredDelegationConnector delegationConnector) {
                if (delegationConnector.getAssemblyContext_RequiredDelegationConnector() == myContext && delegationConnector.getInnerRequiredRole_RequiredDelegationConnector() == requiredRole) {
                    return delegationConnector;
                }
                return null;
            }

            public Connector caseAssemblyConnector(AssemblyConnector assemblyConnector) {
                if (assemblyConnector.getRequiringAssemblyContext_AssemblyConnector() == myContext && assemblyConnector.getRequiredRole_AssemblyConnector() == requiredRole) {
                    return assemblyConnector;
                }
                return null;
            }

            public Connector caseAssemblyInfrastructureConnector(AssemblyInfrastructureConnector assemblyInfrastructureConnector) {
                if (assemblyInfrastructureConnector.getRequiringAssemblyContext__AssemblyInfrastructureConnector() == myContext && assemblyInfrastructureConnector.getRequiredRole__AssemblyInfrastructureConnector() == requiredRole) {
                    return assemblyInfrastructureConnector;
                }
                return null;
            }
        };
        for (Connector connector : myContext.getParentStructure__AssemblyContext().getConnectors__ComposedStructure()) {
            Connector result = (Connector)connectorSelector.doSwitch((EObject)connector);
            if (result == null) continue;
            return result;
        }
        throw new PCMModelInterpreterException("Found unbound provided role. PCM model is invalid.");
    }
}

