/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter;

import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStack;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.parameter.VariableUsage;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.Delay;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.util.UsagemodelSwitch;
import org.palladiosimulator.simulizar.exceptions.PCMModelInterpreterException;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.RepositoryComponentSwitch;
import org.palladiosimulator.simulizar.interpreter.listener.EventType;
import org.palladiosimulator.simulizar.interpreter.listener.ModelElementPassedEvent;
import org.palladiosimulator.simulizar.utils.SimulatedStackHelper;
import org.palladiosimulator.simulizar.utils.TransitionDeterminer;

public class UsageScenarioSwitch<T>
extends UsagemodelSwitch<T> {
    protected static final Logger LOGGER = Logger.getLogger((String)UsageScenarioSwitch.class.getName());
    private final InterpreterDefaultContext context;
    private final TransitionDeterminer transitionDeterminer;

    public UsageScenarioSwitch(InterpreterDefaultContext context) {
        this.context = context;
        this.transitionDeterminer = new TransitionDeterminer(context);
    }

    public T caseBranch(Branch object) {
        BranchTransition branchTransition = this.transitionDeterminer.determineBranchTransition((EList<BranchTransition>)object.getBranchTransitions_Branch());
        this.doSwitch((EObject)branchTransition.getBranchedBehaviour_BranchTransition());
        return (T)super.caseBranch(object);
    }

    public T caseDelay(Delay object) {
        double delay = (Double)StackContext.evaluateStatic((String)object.getTimeSpecification_Delay().getSpecification(), Double.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Start delay " + delay + " @ simulation time " + this.context.getModel().getSimulationControl().getCurrentSimulationTime()));
        }
        this.context.getThread().hold(delay);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Continue user @ simulation time " + this.context.getModel().getSimulationControl().getCurrentSimulationTime()));
        }
        return (T)super.caseDelay(object);
    }

    public T caseEntryLevelSystemCall(EntryLevelSystemCall entryLevelSystemCall) {
        RepositoryComponentSwitch providedDelegationSwitch = new RepositoryComponentSwitch(this.context, RepositoryComponentSwitch.SYSTEM_ASSEMBLY_CONTEXT, (Signature)entryLevelSystemCall.getOperationSignature__EntryLevelSystemCall(), (ProvidedRole)entryLevelSystemCall.getProvidedRole_EntryLevelSystemCall());
        this.context.getRuntimeState().getEventNotificationHelper().firePassedEvent(new ModelElementPassedEvent<EntryLevelSystemCall>(entryLevelSystemCall, EventType.BEGIN, this.context.getThread()));
        this.context.getRuntimeState().getEventNotificationHelper().firePassedEvent(new ModelElementPassedEvent<OperationSignature>(entryLevelSystemCall.getOperationSignature__EntryLevelSystemCall(), EventType.BEGIN, this.context.getThread()));
        SimulatedStackHelper.createAndPushNewStackFrame((SimulatedStack<Object>)this.context.getStack(), (EList<VariableUsage>)entryLevelSystemCall.getInputParameterUsages_EntryLevelSystemCall());
        providedDelegationSwitch.doSwitch((EObject)entryLevelSystemCall.getProvidedRole_EntryLevelSystemCall());
        this.context.getStack().removeStackFrame();
        this.context.getRuntimeState().getEventNotificationHelper().firePassedEvent(new ModelElementPassedEvent<EntryLevelSystemCall>(entryLevelSystemCall, EventType.END, this.context.getThread()));
        this.context.getRuntimeState().getEventNotificationHelper().firePassedEvent(new ModelElementPassedEvent<OperationSignature>(entryLevelSystemCall.getOperationSignature__EntryLevelSystemCall(), EventType.END, this.context.getThread()));
        return (T)super.caseEntryLevelSystemCall(entryLevelSystemCall);
    }

    public T caseLoop(Loop object) {
        int numberOfLoops = (Integer)StackContext.evaluateStatic((String)object.getLoopIteration_Loop().getSpecification(), Integer.class);
        int i = 0;
        while (i < numberOfLoops) {
            LOGGER.debug((Object)("Interpret loop number " + i));
            this.doSwitch((EObject)object.getBodyBehaviour_Loop());
            LOGGER.debug((Object)("Finished loop number " + i));
            ++i;
        }
        return (T)super.caseLoop(object);
    }

    public T caseScenarioBehaviour(ScenarioBehaviour object) {
        for (AbstractUserAction abstractUserAction : object.getActions_ScenarioBehaviour()) {
            if (!(abstractUserAction instanceof Start)) continue;
            this.doSwitch((EObject)abstractUserAction);
            break;
        }
        return (T)super.caseScenarioBehaviour(object);
    }

    public T caseAbstractUserAction(AbstractUserAction object) {
        if (object.getSuccessor() != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Interpret " + object.getSuccessor().eClass().getName() + ": " + object));
            }
            this.doSwitch((EObject)object.getSuccessor());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Finished Interpretation of " + object.getSuccessor().eClass().getName() + ": " + object));
            }
        }
        return (T)super.caseAbstractUserAction(object);
    }

    public T caseUsageScenario(UsageScenario usageScenario) {
        this.context.getRuntimeState().getEventNotificationHelper().firePassedEvent(new ModelElementPassedEvent<UsageScenario>(usageScenario, EventType.BEGIN, this.context.getThread()));
        int stacksize = this.context.getStack().size();
        this.doSwitch((EObject)usageScenario.getScenarioBehaviour_UsageScenario());
        if (this.context.getStack().size() != stacksize) {
            throw new PCMModelInterpreterException("Interpreter did not pop all pushed stackframes");
        }
        this.context.getRuntimeState().getEventNotificationHelper().firePassedEvent(new ModelElementPassedEvent<UsageScenario>(usageScenario, EventType.END, this.context.getThread()));
        return (T)super.caseUsageScenario(usageScenario);
    }
}

