/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter.listener;

import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import java.util.HashMap;
import java.util.Map;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.measurementframework.listener.MeasurementSource;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.recorderframework.IRecorder;
import org.palladiosimulator.recorderframework.utils.RecorderExtensionHelper;
import org.palladiosimulator.simulizar.interpreter.listener.ProbeFrameworkListener;

public abstract class AbstractRecordingProbeFrameworkListenerDecorator {
    private ProbeFrameworkListener probeFrameworkListener;

    public void setProbeFrameworkListener(ProbeFrameworkListener probeFrameworkListener) {
        this.probeFrameworkListener = probeFrameworkListener;
    }

    public void registerMeasurements() {
        if (this.probeFrameworkListener == null) {
            throw new IllegalStateException("No ProbeFrameworkListener at hand. Ensure that setProbeFrameworkListener(..) has been called beforehand.");
        }
    }

    protected ProbeFrameworkListener getProbeFrameworkListener() {
        return this.probeFrameworkListener;
    }

    protected IRecorder initializeRecorder(Map<String, Object> recorderConfigMap) {
        assert (recorderConfigMap != null);
        SimuComConfig config = this.probeFrameworkListener.getSimuComModel().getConfiguration();
        IRecorder recorder = RecorderExtensionHelper.instantiateRecorderImplementationForRecorder((String)config.getRecorderName());
        recorder.initialize(config.getRecorderConfigurationFactory().createRecorderConfiguration(recorderConfigMap));
        return recorder;
    }

    protected void registerMeasurementsRecorder(MeasurementSource measurementSource, IRecorder recorder) {
        assert (measurementSource != null && recorder != null);
        measurementSource.addObserver((IMeasurementSourceListener)recorder);
    }

    protected static Map<String, Object> createRecorderConfigMapWithAcceptedMetricAndMeasuringPoint(MetricDescription recorderAcceptedMetric, MeasuringPoint measuringPoint) {
        assert (recorderAcceptedMetric != null);
        assert (measuringPoint != null);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("recorderAcceptedMetric", recorderAcceptedMetric);
        result.put("measuringPoint", measuringPoint);
        return result;
    }
}

