/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter.listener;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.simulizar.interpreter.listener.AbstractInterpreterListener;
import org.palladiosimulator.simulizar.interpreter.listener.ModelElementPassedEvent;
import org.palladiosimulator.simulizar.interpreter.listener.RDSEFFElementPassedEvent;

public class LogDebugListener
extends AbstractInterpreterListener {
    private static final Logger LOGGER = Logger.getLogger(LogDebugListener.class);

    @Override
    public void beginUsageScenarioInterpretation(ModelElementPassedEvent<UsageScenario> event) {
        this.logEvent(event);
    }

    @Override
    public void endUsageScenarioInterpretation(ModelElementPassedEvent<UsageScenario> event) {
        this.logEvent(event);
    }

    @Override
    public void beginEntryLevelSystemCallInterpretation(ModelElementPassedEvent<EntryLevelSystemCall> event) {
        this.logEvent(event);
    }

    @Override
    public void endEntryLevelSystemCallInterpretation(ModelElementPassedEvent<EntryLevelSystemCall> event) {
        this.logEvent(event);
    }

    @Override
    public void beginExternalCallInterpretation(RDSEFFElementPassedEvent<ExternalCallAction> event) {
        this.logEvent(event);
    }

    @Override
    public void endExternalCallInterpretation(RDSEFFElementPassedEvent<ExternalCallAction> event) {
        this.logEvent(event);
    }

    @Override
    public <T extends EObject> void beginUnknownElementInterpretation(ModelElementPassedEvent<T> event) {
        this.logEvent(event);
    }

    @Override
    public <T extends EObject> void endUnknownElementInterpretation(ModelElementPassedEvent<T> event) {
        this.logEvent(event);
    }

    @Override
    public void beginSystemOperationCallInterpretation(ModelElementPassedEvent<OperationSignature> event) {
        this.logEvent(event);
    }

    @Override
    public void endSystemOperationCallInterpretation(ModelElementPassedEvent<OperationSignature> event) {
        this.logEvent(event);
    }

    private <T extends EObject> void logEvent(ModelElementPassedEvent<T> event) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder msgBuilder = new StringBuilder();
            switch (event.getEventType()) {
                case BEGIN: {
                    msgBuilder.append("Starting to interpret ");
                    break;
                }
                case END: {
                    msgBuilder.append("Finished interpreting ");
                }
                default: {
                    msgBuilder.append("Unknown event ");
                }
            }
            msgBuilder.append(event.getModelElement().eClass().getName());
            msgBuilder.append(" in Simuation Thread \"");
            msgBuilder.append(event.getThread().getId());
            msgBuilder.append("\" at simulation time ");
            msgBuilder.append(event.getPassageTime());
            LOGGER.debug((Object)msgBuilder.toString());
        }
    }
}

