/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.launcher.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.edp2source.Edp2DataTupleDataSource;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting;
import org.palladiosimulator.edp2.models.ExperimentData.Measurement;
import org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange;
import org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjective;
import org.palladiosimulator.servicelevelobjective.edp2.filters.SLOViolationEDP2DatasourceFilter;
import org.palladiosimulator.simulizar.access.ModelAccessUseOriginalReferences;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;

public class EvaluateResultsJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private final Logger LOGGER = Logger.getLogger(EvaluateResultsJob.class);
    private final SimuLizarWorkflowConfiguration configuration;
    private ExperimentSetting experimentSetting;
    private EList<ServiceLevelObjective> serviceLevelObjectives;

    public EvaluateResultsJob(SimuLizarWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }

    public void cleanup(IProgressMonitor arg0) throws CleanupFailedException {
    }

    public void execute(IProgressMonitor progressMonitor) throws JobFailedException, UserCanceledException {
        PCMResourceSetPartition partition = (PCMResourceSetPartition)((MDSDBlackboard)this.getBlackboard()).getPartition("org.palladiosimulator.pcmmodels.partition");
        if (partition == null) {
            this.LOGGER.info((Object)"No Service level objectives provided. Skipping evaluation of experiment data");
        } else {
            String repositoryId = (String)this.configuration.getAttributes().get("EDP2RepositoryID");
            String basename = this.configuration.getSimulationConfiguration().getNameBase();
            String variation = this.configuration.getSimulationConfiguration().getVariationId();
            ModelAccessUseOriginalReferences modelAccess = new ModelAccessUseOriginalReferences((MDSDBlackboard)this.getBlackboard());
            this.serviceLevelObjectives = modelAccess.getServiceLevelObjectiveRepositoryModel().getServicelevelobjectives();
            Repository repository = RepositoryManager.getRepositoryFromUUID((String)repositoryId);
            ExperimentGroup experimentGroup = this.getExperimentGroup(repository, basename);
            this.experimentSetting = this.getExperimentSetting(experimentGroup, variation);
            this.LOGGER.info((Object)("Evaluating data in repository " + repository.getId() + " in experiment run " + basename));
            int lastExperiment = this.experimentSetting.getExperimentRuns().size() - 1;
            this.experimentSetting.getExperimentRuns().get(lastExperiment);
            long[] sloViolations = this.computeSloViolations();
            if (sloViolations[1] == 0L) {
                this.LOGGER.info((Object)"THE STATE WITH NO SLO VIOLATIONS WAS REACHED.");
                progressMonitor.setCanceled(true);
                progressMonitor.done();
            }
            this.LOGGER.info((Object)("Service level objectives were violated in " + sloViolations[1] + " measurements within a total of " + sloViolations[0] + " measurments."));
        }
    }

    public String getName() {
        return "Evaluating Analysis Results";
    }

    private long[] computeSloViolations() {
        int lastExperiment = this.experimentSetting.getExperimentRuns().size() - 1;
        ExperimentRun experimentRun = (ExperimentRun)this.experimentSetting.getExperimentRuns().get(lastExperiment);
        long totalMeasurements = 0L;
        long sloViolations = 0L;
        for (ServiceLevelObjective serviceLevelObjective : this.serviceLevelObjectives) {
            Measurement measurement = this.findMeasurement((List<Measurement>)experimentRun.getMeasurement(), serviceLevelObjective);
            RawMeasurements rawMeasurements = ((MeasurementRange)measurement.getMeasurementRanges().get(0)).getRawMeasurements();
            HashMap<String, ServiceLevelObjective> properties = new HashMap<String, ServiceLevelObjective>(1);
            properties.put("serviceLevelObjective", serviceLevelObjective);
            Edp2DataTupleDataSource dataSource = new Edp2DataTupleDataSource(rawMeasurements);
            MetricDescription metricDescription = dataSource.getMetricDesciption();
            totalMeasurements += (long)dataSource.getDataStream().size();
            SLOViolationEDP2DatasourceFilter sloFilter = new SLOViolationEDP2DatasourceFilter((IDataSource)dataSource, metricDescription);
            sloFilter.setProperties(properties);
            IDataStream dataStream = sloFilter.getDataStream();
            sloViolations += (long)dataStream.size();
            dataStream.close();
        }
        long[] result = new long[]{totalMeasurements, sloViolations};
        return result;
    }

    private Measurement findMeasurement(List<Measurement> measurementList, ServiceLevelObjective serviceLevelObjective) {
        for (Measurement measurement : measurementList) {
            String sloMeasuringPoint;
            String measureMeasuringPoint;
            if (!this.containsMetric(measurement.getMeasuringType().getMetric(), serviceLevelObjective.getMeasurementSpecification().getMetricDescription()) || !(measureMeasuringPoint = measurement.getMeasuringType().getMeasuringPoint().getStringRepresentation()).equals(sloMeasuringPoint = serviceLevelObjective.getMeasurementSpecification().getMonitor().getMeasuringPoint().getStringRepresentation())) continue;
            return measurement;
        }
        throw new RuntimeException("Measurement for SLO \"" + serviceLevelObjective.getName() + "\" not found");
    }

    private boolean containsMetric(MetricDescription metric, MetricDescription metricToCheckFor) {
        if (metric == metricToCheckFor || metric.getId().equals(metricToCheckFor.getId())) {
            return true;
        }
        if (metric instanceof MetricSetDescription) {
            for (MetricDescription subMetric : ((MetricSetDescription)metric).getSubsumedMetrics()) {
                if (!this.containsMetric(subMetric, metricToCheckFor)) continue;
                return true;
            }
        }
        return false;
    }

    private ExperimentGroup getExperimentGroup(Repository repository, String purpose) {
        for (ExperimentGroup experimentGroup : repository.getExperimentGroups()) {
            if (!experimentGroup.getPurpose().equals(purpose)) continue;
            return experimentGroup;
        }
        throw new IllegalArgumentException("Could not find experiment group with purpose \"" + purpose + "\"");
    }

    private ExperimentSetting getExperimentSetting(ExperimentGroup experimentGroup, String experimentSettingDescription) {
        for (ExperimentSetting expSetting : experimentGroup.getExperimentSettings()) {
            if (!expSetting.getDescription().equals(experimentSettingDescription)) continue;
            return expSetting;
        }
        throw new IllegalArgumentException("Could not find experiment setting for variation \"" + experimentSettingDescription + "\"");
    }
}

