/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.launcher.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.simulizar.exceptions.MonitorRepositoryModelLoadException;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;

public class LoadMonitorRepositoryModelIntoBlackboardJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private MDSDBlackboard blackboard;
    private final SimuLizarWorkflowConfiguration configuration;
    private static final String FILE_PREFIX = "file:///";

    public LoadMonitorRepositoryModelIntoBlackboardJob(SimuLizarWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        if (this.getPCMResourceSetPartition() == null) {
            throw new MonitorRepositoryModelLoadException("The PCM models must be loaded first");
        }
        PCMResourceSetPartition monitorRepositoryPartition = this.getPCMResourceSetPartition();
        if (!this.getPath().equals("")) {
            String filePath = this.getPath();
            if (!filePath.startsWith("platform:") && !filePath.startsWith(FILE_PREFIX)) {
                filePath = FILE_PREFIX + filePath;
            }
            monitorRepositoryPartition.loadModel(URI.createURI((String)filePath));
        }
        monitorRepositoryPartition.resolveAllProxies();
    }

    private MDSDBlackboard getBlackboard() {
        return this.blackboard;
    }

    public String getName() {
        return "Perform Monitor Repository Load";
    }

    private String getPath() {
        return this.configuration.getMonitorRepositoryFile();
    }

    private PCMResourceSetPartition getPCMResourceSetPartition() {
        return (PCMResourceSetPartition)this.getBlackboard().getPartition("org.palladiosimulator.pcmmodels.partition");
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

