/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.launcher.jobs;

import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.commons.eclipseutils.ExtensionHelper;
import org.palladiosimulator.simulizar.access.ModelAccessUseOriginalReferences;
import org.palladiosimulator.simulizar.launcher.IConfigurator;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.runtimestate.IRuntimeStateAccessor;
import org.palladiosimulator.simulizar.runtimestate.SimuLizarRuntimeState;

public class PCMStartInterpretationJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger((String)PCMStartInterpretationJob.class.getName());
    private MDSDBlackboard blackboard;
    private final SimuLizarWorkflowConfiguration configuration;

    public PCMStartInterpretationJob(SimuLizarWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        LOGGER.info((Object)("Start job: " + this));
        LOGGER.info((Object)"Initialise Simulizar runtime state");
        List configurators = ExtensionHelper.getExecutableExtensions((String)"org.palladiosimulator.simulizar.configurator", (String)"configurator");
        for (IConfigurator configurator : configurators) {
            configurator.configure(this.configuration, this.blackboard);
        }
        this.configuration.setReconfigurationRulesFolder(this.configuration.getReconfigurationRulesFolder());
        SimuLizarRuntimeState runtimeState = new SimuLizarRuntimeState(this.configuration, new ModelAccessUseOriginalReferences(this.blackboard));
        this.initializeRuntimeStateAccessors(runtimeState);
        runtimeState.runSimulation();
        runtimeState.cleanUp();
        LOGGER.info((Object)("finished job: " + this));
    }

    private void initializeRuntimeStateAccessors(SimuLizarRuntimeState runtimeState) {
        List stateAccessors = ExtensionHelper.getExecutableExtensions((String)"org.palladiosimulator.simulizar.runtimestate.runtimestateaccessor", (String)"accessor");
        for (IRuntimeStateAccessor accessor : stateAccessors) {
            accessor.setRuntimeStateModel(runtimeState);
        }
    }

    public String getName() {
        return "Run SimuLizar";
    }

    public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

