/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.metrics;

import de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.IStateListener;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import java.util.ArrayList;
import org.palladiosimulator.monitorrepository.Intervall;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurement;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementFactory;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;

public class ResourceStateListener
implements IStateListener {
    private double start = 0.0;
    private double lastSimulationTime = 0.0;
    private final ArrayList<Double> measurements = new ArrayList();
    private boolean lastTimeIdle = true;
    private final double timeIntervall;
    private final RuntimeMeasurement measurement;
    private final ISimulationControl simulationControl;

    public ResourceStateListener(AbstractScheduledResource abstractScheduledResource, ISimulationControl iSimulationControl, MeasurementSpecification measurementSpecification, ResourceContainer resourceContainer, RuntimeMeasurementModel prm) {
        this.timeIntervall = ((Intervall)measurementSpecification.getTemporalRestriction()).getIntervall();
        this.simulationControl = iSimulationControl;
        this.lastSimulationTime = this.simulationControl.getCurrentSimulationTime();
        this.measurement = RuntimeMeasurementFactory.eINSTANCE.createRuntimeMeasurement();
        this.measurement.setMeasurementSpecification(measurementSpecification);
        this.measurement.setMeasuringPoint(measurementSpecification.getMonitor().getMeasuringPoint());
        prm.getMeasurements().add((Object)this.measurement);
        abstractScheduledResource.addStateListener((IStateListener)this, ((ActiveResourceMeasuringPoint)this.measurement.getMeasuringPoint()).getReplicaID());
    }

    private void addToPRM(double value) {
        this.measurement.setMeasuringValue(value);
    }

    public void stateChanged(long queueLength, int instanceId) {
        if (this.simulationControl.isRunning()) {
            double simulationTime = this.simulationControl.getCurrentSimulationTime();
            if (this.lastTimeIdle) {
                this.lastTimeIdle = false;
                double idleTime = simulationTime - this.lastSimulationTime;
                this.measurements.add(idleTime);
            }
            if (simulationTime <= this.start + this.timeIntervall) {
                if (queueLength == 0L) {
                    this.lastTimeIdle = true;
                }
            } else {
                this.start = simulationTime;
                double utilization = 1.0 - this.summArray(this.measurements) / this.timeIntervall;
                this.addToPRM(utilization);
                this.measurements.clear();
            }
            this.lastSimulationTime = simulationTime;
        }
    }

    private double summArray(ArrayList<Double> list) {
        double sum = 0.0;
        for (Double idleTime : list) {
            sum += idleTime.doubleValue();
        }
        return sum;
    }
}

