/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.metrics.aggregators;

import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import java.util.LinkedList;
import java.util.List;
import javax.measure.Measure;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.Intervall;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.simulizar.metrics.PRMRecorder;
import org.palladiosimulator.simulizar.metrics.aggregators.ArithmeticMean;
import org.palladiosimulator.simulizar.metrics.aggregators.GeometricMean;
import org.palladiosimulator.simulizar.metrics.aggregators.HarmonicMean;
import org.palladiosimulator.simulizar.metrics.aggregators.IStatisticalCharacterization;
import org.palladiosimulator.simulizar.metrics.aggregators.Median;
import org.palladiosimulator.simulizar.simulationevents.PeriodicallyTriggeredSimulationEntity;

public class ResponseTimeAggregator
extends PRMRecorder
implements IMeasurementSourceListener {
    private final List<Double> responseTimes = new LinkedList<Double>();
    private final IStatisticalCharacterization aggregator;

    public ResponseTimeAggregator(SimuComModel model, RuntimeMeasurementModel prmAccess, MeasurementSpecification measurementSpecification, MeasuringPoint measuringPoint) {
        super(prmAccess, measurementSpecification, measuringPoint);
        switch (measurementSpecification.getStatisticalCharacterization()) {
            case ARITHMETIC_MEAN: {
                this.aggregator = new ArithmeticMean();
                break;
            }
            case MEDIAN: {
                this.aggregator = new Median();
                break;
            }
            case GEOMETRIC_MEAN: {
                this.aggregator = new GeometricMean();
                break;
            }
            case HARMONIC_MEAN: {
                this.aggregator = new HarmonicMean();
                break;
            }
            default: {
                throw new UnsupportedOperationException("This aggregator is currently not supported");
            }
        }
        if (!(measurementSpecification.getTemporalRestriction() instanceof Intervall)) {
            throw new UnsupportedOperationException("Only Intervall is currently supported");
        }
        new PeriodicallyTriggeredSimulationEntity(model, 0.0, ((Intervall)measurementSpecification.getTemporalRestriction()).getIntervall()){

            @Override
            protected void triggerInternal() {
                ResponseTimeAggregator.this.finalizeCurrentIntervall();
            }
        };
    }

    private void finalizeCurrentIntervall() {
        if (this.responseTimes.size() > 0) {
            double statisticalCharacterization = this.aggregator.calculateStatisticalCharaterization(this.responseTimes);
            this.updateMeasurementValue(statisticalCharacterization);
            this.responseTimes.clear();
        }
    }

    public void newMeasurementAvailable(MeasuringValue measurement) {
        Measure responseTimeMeasure = measurement.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC);
        this.responseTimes.add(responseTimeMeasure.doubleValue((Unit)SI.SECOND));
    }

    public void preUnregister() {
    }
}

