/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.runtimestate;

import java.util.HashMap;
import java.util.Map;
import org.palladiosimulator.simulizar.runtimestate.FQComponentID;
import org.palladiosimulator.simulizar.runtimestate.SimulatedComponentInstance;

public class ComponentInstanceRegistry {
    private final Map<FQComponentID, SimulatedComponentInstance> componentInstances = new HashMap<FQComponentID, SimulatedComponentInstance>();

    protected ComponentInstanceRegistry() {
    }

    public void addComponentInstance(SimulatedComponentInstance instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Null not allowed as component instance");
        }
        if (this.componentInstances.containsKey(instance.getFqn())) {
            throw new IllegalArgumentException("Component Instance already exists");
        }
        this.componentInstances.put(instance.getFqn(), instance);
    }

    public void removeComponentInstance(SimulatedComponentInstance instance) {
        if (instance == null) {
            throw new IllegalArgumentException("Null not allowed as component instance");
        }
        if (!this.componentInstances.containsKey(instance.getFqn())) {
            throw new IllegalArgumentException("Component Instance must exists");
        }
        this.componentInstances.remove(instance.getFqn());
    }

    public boolean hasComponentInstance(FQComponentID id) {
        if (id == null) {
            throw new IllegalArgumentException("Null not allowed as component instance");
        }
        return this.componentInstances.containsKey(id);
    }

    public SimulatedComponentInstance getComponentInstance(FQComponentID id) {
        if (id == null) {
            throw new IllegalArgumentException("Null not allowed as component instance");
        }
        if (!this.componentInstances.containsKey(id)) {
            throw new IllegalArgumentException("Component Instance must exists");
        }
        return this.componentInstances.get(id);
    }
}

