/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.runtimestate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.palladiosimulator.simulizar.runtimestate.CostTuple;

public class CostModel {
    private final Map<String, List<CostTuple>> container2Cost = new HashMap<String, List<CostTuple>>();

    public void addCostTuple(String containerID, Double timestamp, Double cost) {
        this.addCostTuple(containerID, new CostTuple(timestamp, cost));
    }

    public void addCostTuple(String containerID, CostTuple costTuple) {
        if (this.container2Cost.get(containerID) == null) {
            ArrayList<CostTuple> containerList = new ArrayList<CostTuple>();
            containerList.add(costTuple);
            this.container2Cost.put(containerID, containerList);
        } else {
            this.container2Cost.get(containerID).add(costTuple);
        }
    }

    public List<CostTuple> getCostTuples(String containerID) {
        if (this.container2Cost.get(containerID) == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.container2Cost.get(containerID));
    }

    public List<CostTuple> getCostTuplesForIntervalForContainer(String containerID, Double startTime, Double endTime) {
        List<CostTuple> costTuples = this.getCostTuples(containerID);
        ArrayList<CostTuple> costTuplesInInterval = new ArrayList<CostTuple>();
        for (CostTuple costTuple : costTuples) {
            if (!(costTuple.getPointInTime() >= startTime) || !(costTuple.getPointInTime() < endTime)) continue;
            costTuplesInInterval.add(costTuple);
        }
        return Collections.unmodifiableList(costTuplesInInterval);
    }

    public List<CostTuple> getCostTuplesForInterval(Double startTime, Double endTime) {
        ArrayList<CostTuple> costTuplesInInterval = new ArrayList<CostTuple>();
        for (String id : this.container2Cost.keySet()) {
            costTuplesInInterval.addAll(this.getCostTuplesForIntervalForContainer(id, startTime, endTime));
        }
        return Collections.unmodifiableList(costTuplesInInterval);
    }
}

