/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.runtimestate;

import de.uka.ipd.sdq.simucomframework.ExperimentRunner;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.probes.TakeCurrentSimulationTimeProbe;
import de.uka.ipd.sdq.simucomframework.probes.TakeNumberOfResourceContainersProbe;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationControl;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections15.Closure;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.commons.eclipseutils.ExtensionHelper;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;
import org.palladiosimulator.probeframework.probes.TriggeredProbeList;
import org.palladiosimulator.simulizar.access.IModelAccess;
import org.palladiosimulator.simulizar.access.ModelAccess;
import org.palladiosimulator.simulizar.interpreter.EventNotificationHelper;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.interpreter.listener.BeginReconfigurationEvent;
import org.palladiosimulator.simulizar.interpreter.listener.EndReconfigurationEvent;
import org.palladiosimulator.simulizar.interpreter.listener.EventResult;
import org.palladiosimulator.simulizar.interpreter.listener.LogDebugListener;
import org.palladiosimulator.simulizar.interpreter.listener.ProbeFrameworkListener;
import org.palladiosimulator.simulizar.interpreter.listener.ReconfigurationExecutedEvent;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurationListener;
import org.palladiosimulator.simulizar.reconfiguration.IReconfigurator;
import org.palladiosimulator.simulizar.reconfiguration.Reconfigurator;
import org.palladiosimulator.simulizar.runconfig.SimuLizarWorkflowConfiguration;
import org.palladiosimulator.simulizar.runtimestate.ComponentInstanceRegistry;
import org.palladiosimulator.simulizar.runtimestate.SimuComModelFactory;
import org.palladiosimulator.simulizar.syncer.IModelObserver;
import org.palladiosimulator.simulizar.syncer.ResourceEnvironmentCostObserver;
import org.palladiosimulator.simulizar.syncer.ResourceEnvironmentSyncer;
import org.palladiosimulator.simulizar.syncer.UsageModelSyncer;
import org.palladiosimulator.simulizar.usagemodel.SimulatedUsageModels;
import org.palladiosimulator.simulizar.usagemodel.UsageEvolver;
import org.palladiosimulator.simulizar.utils.MonitorRepositoryUtil;

public class SimuLizarRuntimeState {
    private static final Logger LOGGER = Logger.getLogger(SimuLizarRuntimeState.class);
    private final SimuComModel model;
    private final EventNotificationHelper eventHelper;
    private final ComponentInstanceRegistry componentInstanceRegistry;
    private final InterpreterDefaultContext mainContext;
    private final SimulatedUsageModels usageModels;
    private final ModelAccess modelAccess;
    private final Reconfigurator reconfigurator;
    private final IModelObserver[] modelObservers;
    private long numberOfContainers = 0L;

    public SimuLizarRuntimeState(SimuLizarWorkflowConfiguration configuration, ModelAccess modelAccess) {
        this.modelAccess = modelAccess;
        this.model = SimuComModelFactory.createSimuComModel(configuration);
        this.eventHelper = new EventNotificationHelper();
        this.componentInstanceRegistry = new ComponentInstanceRegistry();
        this.mainContext = new InterpreterDefaultContext(this);
        this.usageModels = new SimulatedUsageModels(this.mainContext);
        this.initializeWorkloadDrivers();
        this.reconfigurator = this.initializeReconfiguratorEngines(configuration, this.model.getSimulationControl());
        this.modelObservers = this.initializeModelSyncers();
        this.initializeInterpreterListeners(this.reconfigurator);
        this.initializeUsageEvolver();
        this.modelAccess.startObservingPcmChanges();
    }

    public final SimuComModel getModel() {
        return this.model;
    }

    public EventNotificationHelper getEventNotificationHelper() {
        return this.eventHelper;
    }

    public final ComponentInstanceRegistry getComponentInstanceRegistry() {
        return this.componentInstanceRegistry;
    }

    public InterpreterDefaultContext getMainContext() {
        return this.mainContext;
    }

    public SimulatedUsageModels getUsageModels() {
        return this.usageModels;
    }

    public IModelAccess getModelAccess() {
        return this.modelAccess;
    }

    public Reconfigurator getReconfigurator() {
        return this.reconfigurator;
    }

    public void runSimulation() {
        LOGGER.debug((Object)"Starting Simulizar simulation...");
        double simRealTimeNano = ExperimentRunner.run((SimuComModel)this.model);
        LOGGER.debug((Object)("Finished Simulation. Simulator took " + simRealTimeNano / Math.pow(10.0, 9.0) + " real time seconds"));
    }

    public void cleanUp() {
        LOGGER.debug((Object)"Deregister all listeners and execute cleanup code");
        this.eventHelper.removeAllListener();
        this.reconfigurator.removeAllObserver();
        this.reconfigurator.cleanUp();
        this.modelAccess.stopObservingPcmChanges();
        this.model.getProbeFrameworkContext().finish();
        this.model.getConfiguration().getRecorderConfigurationFactory().finalizeRecorderConfigurationFactory();
        IModelObserver[] iModelObserverArray = this.modelObservers;
        int n = this.modelObservers.length;
        int n2 = 0;
        while (n2 < n) {
            IModelObserver modelObserver = iModelObserverArray[n2];
            modelObserver.unregister();
            ++n2;
        }
    }

    private void initializeWorkloadDrivers() {
        LOGGER.debug((Object)"Initialise simucom framework's workload drivers");
        this.model.setUsageScenarios(this.usageModels.getWorkloadDrivers());
    }

    private void initializeInterpreterListeners(Reconfigurator reconfigurator) {
        LOGGER.debug((Object)"Adding Debug and monitoring interpreter listeners");
        this.eventHelper.addObserver(new LogDebugListener());
        this.eventHelper.addObserver(new ProbeFrameworkListener(this.modelAccess, this.model, reconfigurator));
    }

    private Reconfigurator initializeReconfiguratorEngines(SimuLizarWorkflowConfiguration configuration, ISimulationControl simulationControl) {
        LOGGER.debug((Object)"Initializing reconfigurator engines and their rule sets");
        final TriggeredProbe numberOfResourceCalculatorsProbes = this.initNumberOfResourceContainersCalculator();
        List reconfigEngines = ExtensionHelper.getExecutableExtensions((String)"org.palladiosimulator.simulizar.reconfigurationengine", (String)"reconfigurationEngine");
        for (IReconfigurator reconfigEngine : reconfigEngines) {
            reconfigEngine.setConfiguration(configuration);
            reconfigEngine.setModelAccess(this.modelAccess);
        }
        Reconfigurator reconfigurator = new Reconfigurator(this.model, this.modelAccess, simulationControl, reconfigEngines);
        reconfigurator.addObserver(new IReconfigurationListener(){

            @Override
            public void beginReconfigurationEvent(BeginReconfigurationEvent event) {
            }

            @Override
            public void endReconfigurationEvent(EndReconfigurationEvent event) {
            }

            @Override
            public void reconfigurationExecuted(ReconfigurationExecutedEvent reconfExecutedEvent) {
                if (reconfExecutedEvent.getReconfigurationResult() == EventResult.SUCCESS) {
                    LOGGER.debug((Object)("Successful system reconfiguration lasted " + reconfExecutedEvent.getDuration() + " time units"));
                    LOGGER.debug((Object)"Collected notifications:");
                    CollectionUtils.forAllDo(reconfExecutedEvent.getModelChanges(), (Closure)new Closure<Notification>(){

                        public void execute(Notification notification) {
                            LOGGER.debug((Object)(" " + notification.getNotifier()));
                        }
                    });
                    if (numberOfResourceCalculatorsProbes != null && SimuLizarRuntimeState.this.numberOfContainers != (long)SimuLizarRuntimeState.this.getNumberOfResourceContainers()) {
                        SimuLizarRuntimeState.this.numberOfContainers = SimuLizarRuntimeState.this.getNumberOfResourceContainers();
                        numberOfResourceCalculatorsProbes.takeMeasurement();
                    }
                }
            }
        });
        reconfigurator.startListening();
        return reconfigurator;
    }

    private TriggeredProbe initNumberOfResourceContainersCalculator() {
        MonitorRepository monitorRepository = this.getModelAccess().getMonitorRepositoryModel();
        ResourceEnvironment resourceEnvironment = this.getModelAccess().getGlobalPCMModel().getAllocation().getTargetResourceEnvironment_Allocation();
        for (MeasurementSpecification measurementSpecification : MonitorRepositoryUtil.getMeasurementSpecificationsForElement(monitorRepository, (EObject)resourceEnvironment)) {
            String metricID = measurementSpecification.getMetricDescription().getId();
            if (!metricID.equals(MetricDescriptionConstants.NUMBER_OF_RESOURCE_CONTAINERS.getId())) continue;
            MeasuringPoint measuringPoint = measurementSpecification.getMonitor().getMeasuringPoint();
            TriggeredProbeList numberOfResourceCalculatorsProbes = new TriggeredProbeList((MetricDescription)MetricDescriptionConstants.NUMBER_OF_RESOURCE_CONTAINERS_OVER_TIME, Arrays.asList(new TakeNumberOfResourceContainersProbe(resourceEnvironment), new TakeCurrentSimulationTimeProbe(this.model.getSimulationControl())));
            this.model.getProbeFrameworkContext().getCalculatorFactory().buildNumberOfResourceContainersCalculator(measuringPoint, (Probe)numberOfResourceCalculatorsProbes);
            this.numberOfContainers = this.getNumberOfResourceContainers();
            numberOfResourceCalculatorsProbes.takeMeasurement();
            return numberOfResourceCalculatorsProbes;
        }
        return null;
    }

    private int getNumberOfResourceContainers() {
        return this.getModelAccess().getGlobalPCMModel().getAllocation().getTargetResourceEnvironment_Allocation().getResourceContainer_ResourceEnvironment().size();
    }

    private IModelObserver[] initializeModelSyncers() {
        IModelObserver[] modelSyncers;
        LOGGER.debug((Object)"Initialize model syncers to keep simucom framework objects in sync with global PCM model");
        IModelObserver[] iModelObserverArray = modelSyncers = new IModelObserver[]{new ResourceEnvironmentSyncer(), new UsageModelSyncer(), new ResourceEnvironmentCostObserver()};
        int n = modelSyncers.length;
        int n2 = 0;
        while (n2 < n) {
            IModelObserver modelObserver = iModelObserverArray[n2];
            modelObserver.initialize(this);
            ++n2;
        }
        return modelSyncers;
    }

    private void initializeUsageEvolver() {
        if (this.modelAccess.getUsageEvolutionModel() != null) {
            LOGGER.debug((Object)"Start the code to evolve the usage model over time");
            new UsageEvolver(this).start();
        }
    }
}

