/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.runtimestate;

import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.CalculatorHelper;
import de.uka.ipd.sdq.simucomframework.resources.SimSimpleFairPassiveResource;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.simulizar.interpreter.InterpreterDefaultContext;
import org.palladiosimulator.simulizar.runtimestate.FQComponentID;
import org.palladiosimulator.simulizar.runtimestate.SimulatedComponentInstance;
import org.palladiosimulator.simulizar.utils.MonitorRepositoryUtil;

public class SimulatedBasicComponentInstance
extends SimulatedComponentInstance {
    private final Map<String, IPassiveResource> passiveResourcesMap = new HashMap<String, IPassiveResource>();

    public SimulatedBasicComponentInstance(InterpreterDefaultContext context, FQComponentID fqID, List<PassiveResource> passiveResources) {
        super(context.getRuntimeState(), fqID);
        AssemblyContext myAssCtx = fqID.getAssembyContextPath().get(fqID.getAssembyContextPath().size() - 1);
        for (PassiveResource passiveResource : passiveResources) {
            long initialCount = (Long)StackContext.evaluateStatic((String)passiveResource.getCapacity_PassiveResource().getSpecification(), Long.class, (SimulatedStackframe)context.getStack().currentStackFrame());
            SimSimpleFairPassiveResource simulatedResource = new SimSimpleFairPassiveResource(passiveResource, myAssCtx, (SchedulerModel)this.getRuntimeState().getModel(), Long.valueOf(initialCount));
            this.passiveResourcesMap.put(passiveResource.getId(), (IPassiveResource)simulatedResource);
            MeasurementSpecification measurementSpecification = MonitorRepositoryUtil.isMonitored(context.getRuntimeState().getModelAccess().getMonitorRepositoryModel(), (EObject)passiveResource, (MetricDescription)MetricDescriptionConstants.STATE_OF_PASSIVE_RESOURCE_METRIC);
            if (this.isMonitored(measurementSpecification)) {
                CalculatorHelper.setupPassiveResourceStateCalculator((IPassiveResource)simulatedResource, (SimuComModel)this.getRuntimeState().getModel());
            }
            if (this.isMonitored(measurementSpecification = MonitorRepositoryUtil.isMonitored(context.getRuntimeState().getModelAccess().getMonitorRepositoryModel(), (EObject)passiveResource, (MetricDescription)MetricDescriptionConstants.WAITING_TIME_METRIC))) {
                CalculatorHelper.setupWaitingTimeCalculator((IPassiveResource)simulatedResource, (SimuComModel)this.getRuntimeState().getModel());
            }
            if (!this.isMonitored(measurementSpecification = MonitorRepositoryUtil.isMonitored(context.getRuntimeState().getModelAccess().getMonitorRepositoryModel(), (EObject)passiveResource, (MetricDescription)MetricDescriptionConstants.HOLDING_TIME_METRIC))) continue;
            CalculatorHelper.setupHoldTimeCalculator((IPassiveResource)simulatedResource, (SimuComModel)this.getRuntimeState().getModel());
        }
    }

    private boolean isMonitored(MeasurementSpecification measurementSpecification) {
        return measurementSpecification != null;
    }

    public void acquirePassiveResource(PassiveResource passiveResource, InterpreterDefaultContext context, boolean timeout, double timeoutValue) {
        this.checkAcquireReleasePrecondition(passiveResource);
        this.passiveResourcesMap.get(passiveResource.getId()).acquire((ISchedulableProcess)context.getThread(), 1L, timeout, timeoutValue);
    }

    public void releasePassiveResource(PassiveResource passiveResource, InterpreterDefaultContext context) {
        this.checkAcquireReleasePrecondition(passiveResource);
        this.passiveResourcesMap.get(passiveResource.getId()).release((ISchedulableProcess)context.getThread(), 1L);
    }

    private void checkAcquireReleasePrecondition(PassiveResource passiveResource) {
        if (passiveResource == null || !this.passiveResourcesMap.containsKey(passiveResource.getId())) {
            throw new IllegalArgumentException("Illegal passive resource for this basic component instance passed");
        }
    }
}

