/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.syncer;

import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.probes.TakeCurrentSimulationTimeProbe;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.mdsdprofiles.notifier.MDSDProfilesNotifier;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.probeframework.probes.EventProbe;
import org.palladiosimulator.probeframework.probes.EventProbeList;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.simulizar.runtimestate.CostModel;
import org.palladiosimulator.simulizar.runtimestate.SimuLizarRuntimeState;
import org.palladiosimulator.simulizar.simulationevents.AggregatedContainerCostProbe;
import org.palladiosimulator.simulizar.simulationevents.ContainerCostProbe;
import org.palladiosimulator.simulizar.simulationevents.PeriodicallyTriggeredContainerEntity;
import org.palladiosimulator.simulizar.simulationevents.PeriodicallyTriggeredCostModelEntity;
import org.palladiosimulator.simulizar.syncer.AbstractResourceEnvironmentObserver;
import org.palladiosimulator.simulizar.utils.MonitorRepositoryUtil;

public class ResourceEnvironmentCostObserver
extends AbstractResourceEnvironmentObserver {
    private CostModel costModel;
    private HashMap<String, PeriodicallyTriggeredContainerEntity> periodicallyTriggeredContainerEntities;
    private MonitorRepository monitorRepository;

    private void removeSimulatedResource(ResourceContainer resourceContainer) {
        PeriodicallyTriggeredContainerEntity triggeredEntity = this.periodicallyTriggeredContainerEntities.get(resourceContainer.getId());
        if (triggeredEntity == null) {
            return;
        }
        triggeredEntity.removeEvent();
        this.periodicallyTriggeredContainerEntities.remove(resourceContainer.getId());
    }

    private void initPeriodicCostCalculator(ResourceContainer resourceContainer) {
        if (!StereotypeAPI.isStereotypeApplied((EObject)resourceContainer, (String)"Price")) {
            return;
        }
        this.periodicallyTriggeredContainerEntities.put(resourceContainer.getId(), new PeriodicallyTriggeredContainerEntity(this.runtimeModel.getModel(), this.costModel, resourceContainer));
    }

    private void initPeriodicCostModelCalculator() {
        if (!StereotypeAPI.isStereotypeApplied((EObject)this.model, (String)"CostReport")) {
            return;
        }
        double interval = (Double)StereotypeAPI.getTaggedValue((EObject)this.model, (String)"interval", (String)"CostReport");
        for (MeasurementSpecification measurementSpecification : MonitorRepositoryUtil.getMeasurementSpecificationsForElement(this.monitorRepository, this.model)) {
            SimuComModel simuComModel;
            String metricID = measurementSpecification.getMetricDescription().getId();
            if (metricID.equals(MetricDescriptionConstants.COST_OVER_TIME.getId())) {
                simuComModel = this.runtimeModel.getModel();
                EventProbeList probe = new EventProbeList((MetricDescription)MetricDescriptionConstants.COST_OVER_TIME, (EventProbe)new ContainerCostProbe(new PeriodicallyTriggeredCostModelEntity(simuComModel, this.costModel, interval, interval)), Arrays.asList(new TakeCurrentSimulationTimeProbe(simuComModel.getSimulationControl())));
                simuComModel.getProbeFrameworkContext().getCalculatorFactory().buildCostOverTimeCalculator(measurementSpecification.getMonitor().getMeasuringPoint(), (Probe)probe);
            }
            if (!metricID.equals(MetricDescriptionConstants.AGGREGATED_COST_OVER_TIME.getId())) continue;
            simuComModel = this.runtimeModel.getModel();
            EventProbeList aggregatedProbe = new EventProbeList((MetricDescription)MetricDescriptionConstants.AGGREGATED_COST_OVER_TIME, (EventProbe)new AggregatedContainerCostProbe(new PeriodicallyTriggeredCostModelEntity(simuComModel, this.costModel, interval, interval)), Arrays.asList(new TakeCurrentSimulationTimeProbe(simuComModel.getSimulationControl())));
            simuComModel.getProbeFrameworkContext().getCalculatorFactory().buildAggregatedCostOverTimeCalculator(measurementSpecification.getMonitor().getMeasuringPoint(), (Probe)aggregatedProbe);
        }
    }

    @Override
    public void initialize(SimuLizarRuntimeState runtimeState) {
        super.initialize(runtimeState);
        this.monitorRepository = runtimeState.getModelAccess().getMonitorRepositoryModel();
        this.costModel = new CostModel();
        this.initPeriodicCostModelCalculator();
        this.periodicallyTriggeredContainerEntities = new HashMap();
        for (ResourceContainer resourceContainer : ((ResourceEnvironment)this.model).getResourceContainer_ResourceEnvironment()) {
            this.initPeriodicCostCalculator(resourceContainer);
        }
    }

    @Override
    protected void setTaggedValue(Notification notification) {
        MDSDProfilesNotifier.TaggedValueTuple taggedValueTuple = (MDSDProfilesNotifier.TaggedValueTuple)notification.getNewValue();
        if (ResourceenvironmentPackage.eINSTANCE.getResourceContainer().isInstance(notification.getNotifier()) && taggedValueTuple.getStereotypeName().equals("Price") && taggedValueTuple.getTaggedValueName().equals("unit")) {
            this.initPeriodicCostCalculator((ResourceContainer)notification.getNotifier());
        }
    }

    @Override
    protected void remove(Notification notification) {
        if (notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment_ResourceContainer_ResourceEnvironment()) {
            this.removeSimulatedResource((ResourceContainer)notification.getOldValue());
        } else if (notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment_LinkingResources__ResourceEnvironment() || notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getLinkingResource_CommunicationLinkResourceSpecifications_LinkingResource() || notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getLinkingResource_ConnectedResourceContainers_LinkingResource()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Ignoring sync (remove) of linking resources");
            }
        } else {
            this.logDebugInfo(notification);
        }
    }
}

