/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.syncer;

import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.CalculatorHelper;
import de.uka.ipd.sdq.simucomframework.resources.ScheduledResource;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedResourceContainer;
import de.uka.ipd.sdq.stoex.RandomVariable;
import de.uka.ipd.sdq.stoex.StoexPackage;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.pcm.core.CorePackage;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.runtimemeasurement.RuntimeMeasurementModel;
import org.palladiosimulator.simulizar.metrics.ResourceStateListener;
import org.palladiosimulator.simulizar.runtimestate.SimuLizarRuntimeState;
import org.palladiosimulator.simulizar.syncer.AbstractResourceEnvironmentObserver;
import org.palladiosimulator.simulizar.utils.MonitorRepositoryUtil;

public class ResourceEnvironmentSyncer
extends AbstractResourceEnvironmentObserver {
    private static final Logger LOGGER = Logger.getLogger((String)ResourceEnvironmentSyncer.class.getName());
    private MonitorRepository monitorRepository;
    private RuntimeMeasurementModel runtimeMeasurementModel;

    @Override
    public void initialize(SimuLizarRuntimeState runtimeState) {
        super.initialize(runtimeState);
        this.monitorRepository = runtimeState.getModelAccess().getMonitorRepositoryModel();
        this.runtimeMeasurementModel = runtimeState.getModelAccess().getRuntimeMeasurementModel();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Initializing Simulated ResourcesContainer");
        }
        for (ResourceContainer resourceContainer : ((ResourceEnvironment)this.model).getResourceContainer_ResourceEnvironment()) {
            this.createSimulatedResourceContainer(resourceContainer);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Initialization done");
        }
    }

    @Override
    protected void add(Notification notification) {
        if (notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment_ResourceContainer_ResourceEnvironment()) {
            this.addSimulatedResource((ResourceContainer)notification.getNewValue());
        } else if (notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getResourceContainer_ActiveResourceSpecifications_ResourceContainer()) {
            this.createSimulatedActiveResource((ProcessingResourceSpecification)notification.getNewValue());
        } else if (notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment_LinkingResources__ResourceEnvironment() || notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getLinkingResource_CommunicationLinkResourceSpecifications_LinkingResource() || notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getLinkingResource_ConnectedResourceContainers_LinkingResource()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Ignoring sync (add) of linking resources");
            }
        } else {
            this.logDebugInfo(notification);
        }
    }

    @Override
    protected void remove(Notification notification) {
        if (notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment_ResourceContainer_ResourceEnvironment()) {
            this.removeSimulatedResource((ResourceContainer)notification.getOldValue());
        } else if (notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment_LinkingResources__ResourceEnvironment() || notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getLinkingResource_CommunicationLinkResourceSpecifications_LinkingResource() || notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getLinkingResource_ConnectedResourceContainers_LinkingResource()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Ignoring sync (remove) of linking resources");
            }
        } else {
            this.logDebugInfo(notification);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void set(Notification notification) {
        if (notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getProcessingResourceSpecification_ProcessingRate_ProcessingResourceSpecification()) {
            this.syncProcessingRate((ProcessingResourceSpecification)notification.getNotifier(), notification.getNewStringValue());
            return;
        } else if (notification.getFeature() == CorePackage.eINSTANCE.getPCMRandomVariable_ProcessingResourceSpecification_processingRate_PCMRandomVariable()) {
            PCMRandomVariable pcmRandomVariable = (PCMRandomVariable)notification.getNotifier();
            EObject parent = pcmRandomVariable.eContainer();
            if (!(parent instanceof ProcessingResourceSpecification)) throw new RuntimeException("Unsupported Notification.SET for a PCMRandomVariable with parent " + parent);
            this.syncProcessingRate((ProcessingResourceSpecification)parent, notification.getNewStringValue());
            return;
        } else if (notification.getFeature() == StoexPackage.eINSTANCE.getRandomVariable_Specification()) {
            RandomVariable randomVariable = (RandomVariable)notification.getNotifier();
            EObject parent = randomVariable.eContainer();
            if (!(parent instanceof ProcessingResourceSpecification)) throw new RuntimeException("Unsupported Notification.SET for a RandomVariable with parent " + parent);
            this.syncProcessingRate((ProcessingResourceSpecification)parent, notification.getNewStringValue());
            return;
        } else if (notification.getFeature() == ResourceenvironmentPackage.eINSTANCE.getResourceContainer_ResourceEnvironment_ResourceContainer()) {
            if (!LOGGER.isDebugEnabled()) return;
            LOGGER.debug((Object)"Ignoring syncing that links resource containers to their environment");
            return;
        } else {
            this.logDebugInfo(notification);
        }
    }

    private void createSimulatedResourceContainer(ResourceContainer resourceContainer) {
        AbstractSimulatedResourceContainer simulatedResourceContainer = this.addSimulatedResource(resourceContainer);
        this.addActiveResources(resourceContainer, simulatedResourceContainer);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Added SimulatedResourceContainer: ID: " + resourceContainer.getId() + " " + simulatedResourceContainer));
        }
    }

    private AbstractSimulatedResourceContainer addSimulatedResource(ResourceContainer resourceContainer) {
        return this.runtimeModel.getModel().getResourceRegistry().createResourceContainer(resourceContainer.getId());
    }

    private void removeSimulatedResource(ResourceContainer resourceContainer) {
    }

    private void addActiveResources(ResourceContainer resourceContainer, AbstractSimulatedResourceContainer simulatedResourceContainer) {
        for (ProcessingResourceSpecification processingResource : resourceContainer.getActiveResourceSpecifications_ResourceContainer()) {
            this.createSimulatedActiveResource(processingResource);
        }
    }

    private void createSimulatedActiveResource(ProcessingResourceSpecification processingResource) {
        ResourceContainer resourceContainer = processingResource.getResourceContainer_ProcessingResourceSpecification();
        SimulatedResourceContainer simulatedResourceContainer = (SimulatedResourceContainer)this.getSimulatedResourceContainer(processingResource);
        String schedulingStrategy = this.getSchedulingStrategy(processingResource);
        ScheduledResource scheduledResource = simulatedResourceContainer.addActiveResourceWithoutCalculators(processingResource, new String[0], resourceContainer.getId(), schedulingStrategy);
        this.attachMonitors(processingResource, resourceContainer, schedulingStrategy, scheduledResource);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Added ActiveResource. TypeID: " + this.getActiveResourceTypeID(processingResource) + ", Description: " + ", SchedulingStrategy: " + schedulingStrategy));
        }
    }

    private void syncProcessingRate(ProcessingResourceSpecification processingResourceSpecification, String processingRate) {
        this.getScheduledResource(processingResourceSpecification).setProcessingRate(processingRate);
    }

    private String getActiveResourceTypeID(ProcessingResourceSpecification processingResource) {
        return processingResource.getActiveResourceType_ActiveResourceSpecification().getId();
    }

    private AbstractSimulatedResourceContainer getSimulatedResourceContainer(ProcessingResourceSpecification processingResource) {
        return this.runtimeModel.getModel().getResourceRegistry().getResourceContainer(processingResource.getResourceContainer_ProcessingResourceSpecification().getId());
    }

    private ScheduledResource getScheduledResource(ProcessingResourceSpecification processingResource) {
        String typeId = this.getActiveResourceTypeID(processingResource);
        for (AbstractScheduledResource abstractScheduledResource : this.getSimulatedResourceContainer(processingResource).getActiveResources()) {
            if (!abstractScheduledResource.getResourceTypeId().equals(typeId)) continue;
            return (ScheduledResource)abstractScheduledResource;
        }
        throw new RuntimeException("Did not find scheduled resource for type ID " + typeId);
    }

    private String getSchedulingStrategy(ProcessingResourceSpecification processingResource) {
        String schedulingStrategy = processingResource.getSchedulingPolicy().getId();
        if (schedulingStrategy.equals("ProcessorSharing")) {
            return "PROCESSOR_SHARING";
        }
        if (schedulingStrategy.equals("FCFS")) {
            return "FCFS";
        }
        if (schedulingStrategy.equals("Delay")) {
            return "DELAY";
        }
        throw new RuntimeException("Unknown scheduling strategy");
    }

    private void attachMonitors(ProcessingResourceSpecification processingResource, ResourceContainer resourceContainer, String schedulingStrategy, ScheduledResource scheduledResource) {
        for (MeasurementSpecification measurementSpecification : MonitorRepositoryUtil.getMeasurementSpecificationsForElement(this.monitorRepository, (EObject)processingResource)) {
            String metricID = measurementSpecification.getMetricDescription().getId();
            if (!metricID.equals(MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE.getId()) && !metricID.equals(MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC.getId()) && !metricID.equals(MetricDescriptionConstants.WAITING_TIME_METRIC.getId()) && !metricID.equals(MetricDescriptionConstants.HOLDING_TIME_METRIC.getId()) && !metricID.equals(MetricDescriptionConstants.RESOURCE_DEMAND_METRIC.getId())) continue;
            this.attachResourceStateListener(resourceContainer, scheduledResource, measurementSpecification);
            ActiveResourceMeasuringPoint measuringPoint = (ActiveResourceMeasuringPoint)measurementSpecification.getMonitor().getMeasuringPoint();
            if (metricID.equals(MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE.getId()) || metricID.equals(MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC.getId())) {
                if (schedulingStrategy.equals("PROCESSOR_SHARING")) {
                    if (scheduledResource.getNumberOfInstances() == 1) {
                        CalculatorHelper.setupActiveResourceStateCalculator((AbstractScheduledResource)scheduledResource, (SimuComModel)this.runtimeModel.getModel(), (MeasuringPoint)measuringPoint, (int)measuringPoint.getReplicaID());
                        continue;
                    }
                    CalculatorHelper.setupOverallUtilizationCalculator((AbstractScheduledResource)scheduledResource, (SimuComModel)this.runtimeModel.getModel(), (MeasuringPoint)measuringPoint);
                    continue;
                }
                if (schedulingStrategy.equals("DELAY") || schedulingStrategy.equals("FCFS")) {
                    assert (scheduledResource.getNumberOfInstances() == 1) : "DELAY and FCFS resources are expected to have exactly one core";
                    CalculatorHelper.setupActiveResourceStateCalculator((AbstractScheduledResource)scheduledResource, (SimuComModel)this.runtimeModel.getModel(), (MeasuringPoint)measuringPoint, (int)0);
                    continue;
                }
                throw new IllegalArgumentException("Unknown active resource type instrumented with state metric");
            }
            if (metricID.equals(MetricDescriptionConstants.WAITING_TIME_METRIC.getId()) || metricID.equals(MetricDescriptionConstants.HOLDING_TIME_METRIC.getId()) || !metricID.equals(MetricDescriptionConstants.RESOURCE_DEMAND_METRIC.getId())) continue;
            CalculatorHelper.setupDemandCalculator((AbstractScheduledResource)scheduledResource, (SimuComModel)this.runtimeModel.getModel(), (MeasuringPoint)measuringPoint);
        }
    }

    private void attachResourceStateListener(ResourceContainer resourceContainer, ScheduledResource scheduledResource, MeasurementSpecification measurementSpecification) {
        new ResourceStateListener((AbstractScheduledResource)scheduledResource, this.runtimeModel.getModel().getSimulationControl(), measurementSpecification, resourceContainer, this.runtimeMeasurementModel);
    }
}

