/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.syncer;

import de.uka.ipd.sdq.stoex.StoexPackage;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.CorePackage;
import org.palladiosimulator.pcm.parameter.ParameterPackage;
import org.palladiosimulator.pcm.usagemodel.ClosedWorkload;
import org.palladiosimulator.pcm.usagemodel.OpenWorkload;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;
import org.palladiosimulator.pcm.usagemodel.Workload;
import org.palladiosimulator.simulizar.syncer.AbstractUsageModelObserver;

public class UsageModelSyncer
extends AbstractUsageModelObserver {
    private static final Logger LOGGER = Logger.getLogger(UsageModelSyncer.class);

    @Override
    protected void set(Notification notification) {
        if (UsagemodelPackage.eINSTANCE.getClosedWorkload().isInstance(notification.getNotifier())) {
            this.syncClosedWorkload(notification);
        } else if (CorePackage.eINSTANCE.getPCMRandomVariable().isInstance(notification.getNotifier()) && ((EObject)notification.getNotifier()).eContainer() instanceof OpenWorkload && notification.getFeature() == StoexPackage.eINSTANCE.getRandomVariable_Specification()) {
            this.syncOpenWorkload(notification);
        } else if (!CorePackage.eINSTANCE.getPCMRandomVariable().isInstance(notification.getNotifier()) || !ParameterPackage.eINSTANCE.getVariableCharacterisation().isInstance((Object)((EObject)notification.getNotifier()).eContainer())) {
            LOGGER.error((Object)"Usage model changed...But no resync strategy is known. Simulation results most likely are wrong.");
        }
    }

    private void syncClosedWorkload(Notification notification) {
        ClosedWorkload workload = (ClosedWorkload)notification.getNotifier();
        this.closedWorkloadPopulationChanged((Workload)workload, notification.getNewIntValue());
    }

    private void syncOpenWorkload(Notification notification) {
        OpenWorkload workload = (OpenWorkload)((EObject)notification.getNotifier()).eContainer();
        this.openWorkloadInterarrivalChange((Workload)workload, notification.getNewStringValue());
    }

    private void openWorkloadInterarrivalChange(Workload workload, String newInterarrivalTime) {
        LOGGER.debug((Object)("Setting open workload interarrival time to " + newInterarrivalTime));
        this.runtimeModel.getUsageModels().getOpenWorkloadDriver((OpenWorkload)workload).setInterarrivalTime(newInterarrivalTime);
    }

    private void closedWorkloadPopulationChanged(Workload workload, int newPopulation) {
        LOGGER.debug((Object)("Setting closed workload population to " + newPopulation));
        this.runtimeModel.getUsageModels().getClosedWorkloadDriver((ClosedWorkload)workload).setPopulation(newPopulation);
    }
}

